/*
 *
 * Copyright (C) 2023, IOPSYS Software Solutions AB.
 *
 * Author: vivek.dutta@iopsys.eu
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 * \file vendor_ubus_thread.h
 *
 * Header file containing defines controlling the build of USP Agent,
 * which is added by IOPSYS
 *
 */

#ifndef VENDOR_UBUS_THREAD_H
#define VENDOR_UBUS_THREAD_H

#include <libubus.h>

#define DEFAULT_IPC_TIMEOUT 30000  // 30 Sec
typedef enum
{
	CMD_NULL,
	CMD_GROUP_GET,
	CMD_GROUP_SET,
	CMD_ADD,
	CMD_DEL,
	CMD_GET,
	CMD_SET,
	CMD_OPERATE_SYNC,
	CMD_OPERATE_ASYNC,
	CMD_INSTANCES,
	CMD_TRAN_START,
	CMD_TRAN_COMMIT,
	CMD_TRAN_ABORT,
	CMD_SESSION_MGMT,
	CMD_STOP
} uspd_cmd_t;

typedef struct
{
	uspd_cmd_t cmd;
	int len;
	int inst;
	int fault;
	int ipc_timeout;
	bool is_secured;
	str_vector_t *vec;
	kv_vector_t *kv;
	kv_vector_t *kv_out;
	unsigned *p_types;
	int *p_instance;
	int *p_failure_index;
	const char *path;
	char *p_value;
	char ceid[MAX_DM_PATH];  // controller endpoint id
	char command_key[MAX_DM_PATH];
} vendor_data_t;

int ubus_thread_init();
int ubus_thread_start(void);
int ubus_thread_cleanup(void);
int ubus_enqueue_cmd(vendor_data_t *arg);

// Utility functions
int _get_controller_info(vendor_data_t *arg);
int uspd_call(struct ubus_context *ctx, const char *method, struct blob_buf *data, ubus_data_handler_t callback, vendor_data_t *arg);
int uspd_call_async(const char *method, struct blob_buf *data, ubus_data_handler_t callback, void *priv);
#endif // VENDOR_UBUS_THREAD_H
