# Guide to setup factory default ControllerTrust roles

OB-USP-A does provide mechanism to manage ControllerTrust roles from TR181, follow this guide to setup factory default ControllerTrust Roles.

## Static roles definition

To define static roles, [usermngr's](https://dev.iopsys.eu/bbf/usermngr.git) 'Device.Users.Role.{i}.' table is used, so that It can be used to provision local USP based UI using `Device.UserInterface.` datamodel provided by [userinterface](https://dev.iopsys.eu/bbf/userinterface.git) package.


Following is an example of static role json file

```json
{
  "tr181": {
    "permission": [
      {
        "object": "Device.",
        "perm": [
          "PERMIT_NONE"
        ]
      },
      {
        "object": "Device.SSH.",
        "perm": [
          "PERMIT_GET",
          "PERMIT_GET_INST",
          "PERMIT_OBJ_INFO",
          "PERMIT_CMD_INFO",
          "PERMIT_OPER",
          "PERMIT_SUBS_VAL_CHANGE",
          "PERMIT_SUBS_OBJ_ADD",
          "PERMIT_SUBS_OBJ_DEL",
          "PERMIT_SUBS_EVT_OPER_COMP"
        ]
      }
    ]
  }
}
```

All the static roles needed to be installed in `/etc/users/roles/` directory in CPE.


Following is the mapping between PERMIT flags and datamodel permissions with description

| PERMIT flag                | Datamodel mapping                                              | Description |
| -------------------------- | -------------------------------------------------------------- | ----------- |
| PERMIT_GET                 | ControllerTrust.Role.{i}.Permission.{i}.Param (r---)           | Grants the capability to read the value of the Parameter via Get and read the meta-information of the Parameter via GetSupportedDM |
| PERMIT_SET                 | ControllerTrust.Role.{i}.Permission.{i}.Param (-w--)           | Grants the capability to update the value of the Parameter via Add or Set |
| PERMIT_SUBS_VAL_CHANGE     | ControllerTrust.Role.{i}.Permission.{i}.Param (---n)           | Grants the capability to receive Notify Messages of type ValueChange for this Parameter |
| PERMIT_OBJ_INFO            | ControllerTrust.Role.{i}.Permission.{i}.Obj (r---)             | Grants the capability to read the meta-information of the Object via GetSupportedDM |
| PERMIT_ADD                 | ControllerTrust.Role.{i}.Permission.{i}.Obj (-w--)             | Grants the capability to create a new instance of a Multi-Instanced Object via Add |
| PERMIT_SUBS_OBJ_ADD        | ControllerTrust.Role.{i}.Permission.{i}.Obj (---n)             | Grants the capability to receive Notify Messages of type ObjectCreation for this Object (multi-instance objects only) |
| PERMIT_GET_INST            | ControllerTrust.Role.{i}.Permission.{i}.InstantiatedObj (r---) | Grants the capability to read the instance numbers and unique keys of the Instantiated Object via GetInstances and read the value of Parameters related to the Instantiated Object via a Get containing a search expression or wildcard in place of the instance identifier |
| PERMIT_DEL                 | ControllerTrust.Role.{i}.Permission.{i}.InstantiatedObj (-w--) | Grants the capability to remove an existing instance of an Instantiated Object via Delete |
| PERMIT_SUBS_OBJ_DEL        | ControllerTrust.Role.{i}.Permission.{i}.InstantiatedObj (---n) | Grants the capability to receive Notify Messages of type ObjectDeletion for this Instantiated Object |
| PERMIT_CMD_INFO            | ControllerTrust.Role.{i}.Permission.{i}.CommandEvent (r---)    | Grants the capability to read the meta-information of the Command (including input and output arguments) and Event (including arguments) via GetSupportedDM |
| PERMIT_OPER                | ControllerTrust.Role.{i}.Permission.{i}.CommandEvent (--x-)    | Grants the capability to execute the Command via Operate, but grants no capabilities to an Event |
| PERMIT_SUBS_EVT_OPER_COMP  | ControllerTrust.Role.{i}.Permission.{i}.CommandEvent (---n)    | Grants the capability to receive Notify Messages of type OperationComplete for this Event or Command |
| PERMIT_NONE             | Param(----), Obj(----), InstantiatedObj(----), CommandEvent(----) | Grants no capabilities |
| PERMIT_ALL              | Param(rw-n), Obj(rw-n), InstantiatedObj(rw-n), CommandEvent(r-xn) | Grants all capabilities |


> Note: Internally permissions defined in JSON applied in the same order as they defined in JSON, do check order definition from [TR181](https://usp-data-models.broadband-forum.org/tr-181-2-18-1-usp.html#D.Device:2.Device.LocalAgent.ControllerTrust.Role.Permission.) for permission inheritance.
