/*
 * Copyright (C) 2024-2025 iopsys Software Solutions AB
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 2.1
 * as published by the Free Software Foundation
 *
 *	Author: Amin Ben Romdhane <amin.benromdhane@iopsys.eu>
 */

#include <libbbfdm-api/dmapi.h>

#ifdef NETMNGR_IP_OBJ
#include "ip.h"
#endif

#ifdef NETMNGR_GRE_OBJ
#include "gre.h"
#endif

#ifdef NETMNGR_PPP_OBJ
#include "ppp.h"
#endif

#ifdef NETMNGR_ROUTING_OBJ
#include "routing.h"
#endif

#ifdef NETMNGR_ROUTER_ADVERTISEMENT_OBJ
#include "routeradvertisement.h"
#endif

#ifdef NETMNGR_IPV6RD_OBJ
#include "ipv6rd.h"
#endif

#include "interfacestack.h"

DM_MAP_OBJ tDynamicObj[] = {
/* parentobj, nextobject, parameter */

#ifdef NETMNGR_IP_OBJ
{"Device.", tDeviceIPObj, NULL, init_ip_module, clean_ip_module},
#endif

#ifdef NETMNGR_GRE_OBJ
{"Device.", tDeviceGREObj, NULL, init_gre_module, NULL},
#endif

#ifdef NETMNGR_PPP_OBJ
{"Device.", tDevicePPPObj, NULL, init_ppp_module, NULL},
#endif

#ifdef NETMNGR_ROUTING_OBJ
{"Device.", tDeviceRoutingObj, NULL, init_routing_module, NULL},
#endif

#ifdef NETMNGR_ROUTER_ADVERTISEMENT_OBJ
{"Device.", tDeviceRouterAdvertisementObj, NULL},
#endif

#ifdef NETMNGR_IPV6RD_OBJ
{"Device.", tDeviceIPv6rdObj, NULL, init_ipv6rd_module, NULL},
#endif

{"Device.", tDeviceInterfaceStackObj, tDeviceInterfaceStackParams},

{0}
};
