# mcast Schema

```
https://www.iopsys.eu/mcast.json
```

| Custom Properties | Additional Properties |
| ----------------- | --------------------- |
| Forbidden         | Forbidden             |

# mcast

| List of Methods |
| --------------- |
| [stats](#stats) | Method | mcast (this schema) |

## stats

`stats`

- type: `Method`

### stats Type

`object` with following properties:

| Property | Type   | Required |
| -------- | ------ | -------- |
| `input`  | object | Optional |
| `output` | object | Optional |

#### input

`input`

- is optional
- type: `object`

##### input Type

`object` with following properties:

| Property | Type | Required |
| -------- | ---- | -------- |
| None     | None | None     |

### Ubus CLI Example

```
ubus call mcast stats {}
```

### JSONRPC Example

```json
{ "jsonrpc": "2.0", "id": 0, "method": "call", "params": ["<SID>", "mcast", "stats", {}] }
```

#### output

`output`

- is optional
- type: `object`

##### output Type

`object` with following properties:

| Property   | Type  | Required     |
| ---------- | ----- | ------------ |
| `snooping` | array | **Required** |

#### snooping

`snooping`

- is **required**
- type: `object[]`

##### snooping Type

Array type: `object[]`

All items must be of the type: `object` with following properties:

| Property    | Type   | Required     |
| ----------- | ------ | ------------ |
| `groups`    | array  | **Required** |
| `interface` | string | **Required** |

#### groups

`groups`

- is **required**
- type: `object[]`

##### groups Type

Array type: `object[]`

All items must be of the type: `object` with following properties:

| Property    | Type    | Required     |
| ----------- | ------- | ------------ |
| `clients`   | array   | **Required** |
| `groupaddr` | integer | **Required** |

#### clients

`clients`

- is **required**
- type: `object[]`

##### clients Type

Array type: `object[]`

All items must be of the type: `object` with following properties:

| Property  | Type    | Required     |
| --------- | ------- | ------------ |
| `device`  | string  | **Required** |
| `ipaddr`  | string  | **Required** |
| `timeout` | integer | **Required** |

#### device

`device`

- is **required**
- type: `string`

##### device Type

`string`

- minimum length: 1 characters
- maximum length: 16 characters

#### ipaddr

`ipaddr`

- is **required**
- type: `string`

##### ipaddr Type

`string`

- minimum length: 7 characters
- maximum length: 15 characters

#### timeout

`timeout`

- is **required**
- type: `integer`

##### timeout Type

`integer`

#### groupaddr

`groupaddr`

- is **required**
- type: `integer`

##### groupaddr Type

`integer`

#### interface

##### Interface

`interface`

- is **required**
- type: `string`

##### interface Type

`string`

- minimum length: 1 characters
- maximum length: 16 characters

### Output Example

```json
{
  "snooping": [
    {
      "interface": "occaecat con",
      "groups": [
        {
          "groupaddr": -38391548,
          "clients": [
            { "ipaddr": "doloreid occaec", "device": "et", "timeout": -22444861 },
            { "ipaddr": "sitet magna", "device": "aliquip ul", "timeout": 10821342 },
            { "ipaddr": "Lorem off", "device": "dolor a", "timeout": -42384484 }
          ]
        },
        {
          "groupaddr": 69952824,
          "clients": [
            { "ipaddr": "tempor sit", "device": "aute", "timeout": 46264790 },
            { "ipaddr": "nulla occaecat", "device": "o", "timeout": 55472635 },
            { "ipaddr": "dolor sit o", "device": "dolor", "timeout": -92982335 },
            { "ipaddr": "nisi Duis", "device": "Excepteur ", "timeout": 46218565 },
            { "ipaddr": "ad occaeca", "device": "aliqu", "timeout": 47690221 }
          ]
        }
      ]
    },
    {
      "interface": "Ut amet in repre",
      "groups": [
        {
          "groupaddr": 35406360,
          "clients": [
            { "ipaddr": "et elit", "device": "sit", "timeout": 90813960 },
            { "ipaddr": "amet elit Duis", "device": "no", "timeout": -16277244 },
            { "ipaddr": "incididunt ", "device": "magna velit", "timeout": -49621030 },
            { "ipaddr": "laborum", "device": "tempor e", "timeout": 95988517 }
          ]
        },
        {
          "groupaddr": -45354524,
          "clients": [
            { "ipaddr": "esse molli", "device": "ullamco magna r", "timeout": -45593997 },
            { "ipaddr": "ipsum a", "device": "officia amet ", "timeout": -96168096 },
            { "ipaddr": "eu amet", "device": "pariatur enim i", "timeout": -24864389 },
            { "ipaddr": "proident", "device": "sint", "timeout": -29379609 }
          ]
        },
        { "groupaddr": 55626667, "clients": [{ "ipaddr": "reprehenderit", "device": "e", "timeout": -7378571 }] },
        {
          "groupaddr": -94080578,
          "clients": [
            { "ipaddr": "est pariatur", "device": "nulla", "timeout": -48360279 },
            { "ipaddr": "laborum ", "device": "dolo", "timeout": -39722283 },
            { "ipaddr": "ex nostr", "device": "in", "timeout": -93511259 },
            { "ipaddr": "irure esse", "device": "tempor est do ve", "timeout": -83682237 },
            { "ipaddr": "officia ", "device": "L", "timeout": -16180837 }
          ]
        }
      ]
    }
  ]
}
```
