/*
 * Copyright (C) 2020 iopsys Software Solutions AB
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 2.1
 * as published by the Free Software Foundation
 *
 *	  Author Rahul Thakur <rahul.thakur@iopsys.eu>
 *
 */ 

#ifndef __IOPSYS_COMMON_H
#define __IOPSYS_COMMON_H

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "libbbfdm-api/dmcommon.h"

#define DM_ASSERT_STR(X) \
do { \
        if(!(X)) { \
                return ""; \
        } \
} while(0)

int get_mcast_proxy_enable(char *refparam, struct dmctx *ctx, void *data, char *instance, char **value);
int set_mcast_proxy_enable(char *refparam, struct dmctx *ctx, void *data, char *instance, char *value, int action);
int get_mcast_proxy_fast_leave(char *refparam, struct dmctx *ctx, void *data, char *instance, char **value);
int set_mcast_proxy_fast_leave(char *refparam, struct dmctx *ctx, void *data, char *instance, char *value, int action);
int get_mcast_proxy_robustness(char *refparam, struct dmctx *ctx, void *data, char *instance, char **value);
int set_mcast_proxy_robustness(char *refparam, struct dmctx *ctx, void *data, char *instance, char *value, int action);
int get_mcast_proxy_aggregation(char *refparam, struct dmctx *ctx, void *data, char *instance, char **value);
int set_mcast_proxy_aggregation(char *refparam, struct dmctx *ctx, void *data, char *instance, char *value, int action);
int get_mcast_snooping_enable(char *refparam, struct dmctx *ctx, void *data, char *instance, char **value);
int set_mcast_snooping_enable(char *refparam, struct dmctx *ctx, void *data, char *instance, char *value, int action);
int get_mcast_snooping_robustness(char *refparam, struct dmctx *ctx, void *data, char *instance, char **value);
int set_mcast_snooping_robustness(char *refparam, struct dmctx *ctx, void *data, char *instance, char *value, int action);
int get_mcast_snooping_aggregation(char *refparam, struct dmctx *ctx, void *data, char *instance, char **value);
int set_mcast_snooping_aggregation(char *refparam, struct dmctx *ctx, void *data, char *instance, char *value, int action);
int get_mcast_snooping_interface(char *refparam, struct dmctx *ctx, void *data, char *instance, char **value);
int set_mcast_snooping_interface(char *refparam, struct dmctx *ctx, void *data, char *instance, char *value, int action);
int get_mcast_snooping_mode(char *refparam, struct dmctx *ctx, void *data, char *instance, char **value);
int set_mcast_snooping_mode(char *refparam, struct dmctx *ctx, void *data, char *instance, char *value, int action);
int get_mcasts_fast_leave(char *refparam, struct dmctx *ctx, void *data, char *instance, char **value);
int set_mcasts_fast_leave(char *refparam, struct dmctx *ctx, void *data, char *instance, char *value, int action);
int get_mcasts_last_mq_interval(char *refparam, struct dmctx *ctx, void *data, char *instance, char **value);
int set_mcasts_last_mq_interval(char *refparam, struct dmctx *ctx, void *data, char *instance, char *value, int action);

int get_mcastp_query_interval(char *refparam, struct dmctx *ctx, void *data, char *instance, char **value);
int set_mcastp_query_interval(char *refparam, struct dmctx *ctx, void *data, char *instance, char *value, int action);
int get_mcastp_q_response_interval(char *refparam, struct dmctx *ctx, void *data, char *instance, char **value);
int set_mcastp_q_response_interval(char *refparam, struct dmctx *ctx, void *data, char *instance, char *value, int action);
int get_mcastp_last_mq_interval(char *refparam, struct dmctx *ctx, void *data, char *instance, char **value);
int set_mcastp_last_mq_interval(char *refparam, struct dmctx *ctx, void *data, char *instance, char *value, int action);
int get_mcastp_iface_snoop_mode(char *refparam, struct dmctx *ctx, void *data, char *instance, char **value);
int set_mcastp_iface_snoop_mode(char *refparam, struct dmctx *ctx, void *data, char *instance, char *value, int action);
int get_mcastp_filter_enable(char *refparam, struct dmctx *ctx, void *data, char *instance, char **value);
int set_mcastp_filter_enable(char *refparam, struct dmctx *ctx, void *data, char *instance, char *value, int action);
int del_mcastp_filter_obj(char *refparam, struct dmctx *ctx, void *data, char *instance, unsigned char del_action);
int get_mcastp_interface_upstream(char *refparam, struct dmctx *ctx, void *data, char *instance, char **value);
int get_mcastp_filter_address(char *refparam, struct dmctx *ctx, void *data, char *instance, char **value);

int get_mcasts_filter_enable(char *refparam, struct dmctx *ctx, void *data, char *instance, char **value);
int set_mcasts_filter_enable(char *refparam, struct dmctx *ctx, void *data, char *instance, char *value, int action);
int get_mcasts_filter_address(char *refparam, struct dmctx *ctx, void *data, char *instance, char **value);
int set_mcasts_filter_address(char *refparam, struct dmctx *ctx, void *data, char *instance, char *value, int action);
int del_mcasts_filter_obj(char *refparam, struct dmctx *ctx, void *data, char *instance, unsigned char del_action);

void update_snooping_mode(struct uci_section *s);
int get_mcast_snooping_interface_val(struct dm_reference *reference_args, char *ifname, size_t s_ifname);
int del_proxy_obj(void *data, const char *proto, unsigned char del_action);
void del_dmmap_sec_with_opt_eq(const char *dmmap_file, const char *section, const char *option, const char *value);
void sync_dmmap_bool_to_uci_list(struct uci_section *s, const char *section, const char *value, bool b);
int del_snooping_obj(void *data);
int browse_proxy_interface_inst(struct dmctx *dmctx, DMNODE *parent_node, void *prev_data, const char *proto);
int browse_filter_inst(struct dmctx *dmctx, DMNODE *parent_node, void *prev_data, const char *section_type,
		const char *option_name, const char *option_value);
void synchronize_specific_config_sections_with_dmmap_mcast_iface(const char *package, const char *section_type,
		void *data, const char *dmmap_package, const char *dmmap_sec, const char *proto,
		struct list_head *dup_list);
void synchronize_specific_config_sections_with_dmmap_mcast_filter(const char *package, const char *section_type,
		void *data, const char *dmmap_package, const char *dmmap_sec, const char *proto,
		struct list_head *dup_list);

void sync_proxy_interface_sections(struct uci_section *s, const char *section, const char *value, bool up_iface);
void set_iface_val(void *data, char *instance, char *linker, char *interface_linker, bool is_br);
int set_mcastp_iface_snoop_mode(char *refparam, struct dmctx *ctx, void *data, char *instance, char *value, int action);
void sync_proxy_interface_sections(struct uci_section *s, const char *section, const char *value, bool up_iface);
void set_iface_val(void *data, char *instance, char *linker, char *interface_linker, bool is_br);
void get_mcast_iface_key(const char *p_ifname, char *key, size_t key_size);
int set_interface_iface(char *refparam, struct dmctx *ctx, void *data, char *instance, char *value, int action);
int set_interface_upstream(char *refparam, struct dmctx *ctx, void *data, char *instance, char *value, int action);

#endif //__IOPSYS_COMMON_H
