# Multicast Manager

`mcastmgr` is used for configuring IGMP and MLD snooping and proxy.

## UCI Config

`mcastmgr` requires a configuration file provide objects over ubus. The configuration file is an uci file `/etc/config/mcast`. Sample configuration file is provided below.

```
config igmp 'igmp'
        option max_membership '20'
        option max_msf '10'
        option qrv '2'
        option force_version '0'

config mld 'mld'
        option mldv1_unsolicited_report_interval '10'
        option mldv2_unsolicited_report_interval '1'
        option qrv '2'
        option force_version '0'

config proxy 'igmp_proxy_1'
        option enable '1'
        option proto 'igmp'
        option version '2'
        option robustness '2'
        option query_interval '125'
        option query_response_interval '100'
        option last_member_query_interval '10'
        option fast_leave '1'
        option snooping_mode '2'
        list downstream_interface 'br-lan'
        list upstream_interface 'eth0.1'
        list filter '239.0.0.0/8'
```

## uBus API

`ubusd` has to be running all time, as `mcastmgr` exposes the IGMP/MLD info and stats over ubus.

```
root@iopsys:~# ubus list |grep mcast 
mcast
```

```
root@iopsys:~# ubus -v list mcast
'mcast' @14a15a56
        "stats":{}
root@iopsys:~# 
```

