## Overview
This STA steering plugin is for Controller initiated STA steering mandate, which is based on the estimated throughput achievable by a STA from roaming to another (better) AP.

The steer trigger condition is defined as following - 
Whenever the STA's current estimated max downlink throughput is below a threshold value (defined in percentage of the theoritical max downlink throughput), the "rate.so" plugin will start looking actively for a better Neighbor AP in the same Multi-AP network.

The decision to steer STA is based on the following algorithm -
The "rate.so" plugin uses 'Unassociated-STA metrics query/response' messages to determine the estimated uplink-SNR that a neighboring AP will get from the STA. From the uplink-SNR, the estimated downlink throughput from the neighboring AP is calculated. Since the neighboring AP may be connected via Wi-Fi backhaul in the Multi-AP network, the effective max-throughput that the neighboring AP can provide to the STA is thus caped to the maximum of the backhaul downlink rate of the neighboring AP and the estimated fronthaul downlink rate.
Only when the effective estimated downlink throughput of the neighboring AP is greater than the current estimate by "boost" value, will the "rate.so" plugin give verdict=STEER_OK to the Controller.

>Limitations: When a neighboring AP in the Multi-AP network cannot provide 'Unassociated-STA metrics response' with valid uplink-RCPI for the STA, the estimated downlink throughput with the target AP cannot be derived. Consequently, the "rate.so" plugin will have no basis to compare STA's current achievable throughput with that of the target AP's, thus taking no steering decision for the STA to the target AP.
Example scenario -  When an Extender has wired backhaul, the APs in the Extender may run at different channels than the upstream APs. Now, since Off-Channel monitoring of unassociated STAs is not supported mainly due to performance reason, the Extender cannot reply back with valid monitored data of the STA in off-channels. Thus, 'rate.so' will have no basis to decide on steering the STA to the Extender's AP.

## Configuration

In mapcontroller's config file "/etc/config/mapcontroller", a config section "sta-steer" with name "rate" is used to add the plugin specific configuration options -

````
config sta-steer 'rate'
	option enabled '1              # rate plugin is enabled or not
	option steer_int '180'         # steer interval in seconds between successive steering attempts
	option threshold '40'          # percentage of max estimated throughput
	option boost '20'              # target-AP should be better by this amount (in Mbps)
	option bandsteer '0            # allow steering to different band when set to 1
	option max_steer_attempt '-1'  # max steer attempts in a connection session. -1 = unlimited.

````

The values appearing above are the default values for the config options.
