#ifndef LIB_ZEROUTOUCH_H
#define LIB_ZEROUTOUCH_H

/* Generates encoded DPP-URI payload. Returns payload with length 'olen' */
uint8_t *dpp_gen_encoded_uri_payload(void *ap_pubkey, void *own_key, const char *uri, size_t *olen);

/* Generates Public Action vendor specific frame with passed 'payload'.
 * Returns constructed frame, with length 'olen'.
 */
uint8_t *dpp_gen_pa_vsie_frame(uint8_t *payload, size_t len, size_t *olen);

/* Function processeses Public Action frame of Vendor Spec type
 * Outputs 'uri' if frame is valid.
 * Returns 0 on Success, -1 on Failure.
 */
int dpp_process_pa_vsie_frame(void *ap_key, uint8_t *frame, size_t framelen, char **uri);


/* Following functions for frame type 0xb */
uint8_t *dpp_gen_pa_vsie_frame2(uint8_t *payload, size_t len, size_t *olen);
uint8_t *dpp_gen_encoded_uri_payload2(char *passphrase, const char *uri, size_t *olen);
int dpp_process_pa_vsie_frame2(char *passphrase, uint8_t *frame, size_t framelen, char **uri);

#endif /* LIB_ZEROUTOUCH_H */
