#!/bin/bash

echo "install dependencies"

home=$(pwd)

function exec_cmd()
{
	echo "executing $@"
	$@ >/dev/null 2>&1
	local ret=$?

	if [ "${ret}" -ne 0 ]; then
		echo "Failed to execute $@ ret (${ret})"
		exit 1
	fi
}


# libeasy.so
cd /opt/dev
rm -fr libeasy
mkdir -p /usr/include/easy
exec_cmd git clone -b devel https://dev.iopsys.eu/iopsys/libeasy.git
cd libeasy
exec_cmd cmake .
exec_cmd make CFLAGS+="-I/usr/include/libnl3"
exec_cmd mkdir -p /usr/include/easy
exec_cmd cp easy.h event.h utils.h if_utils.h debug.h hlist.h bufutil.h cryptutil.h ecc_cryptutil.h timestamp.h /usr/include/easy
exec_cmd cp -a libeasy*.so* /usr/lib


# libwifiutils
cd /opt/dev
rm -fr libwifiutils
exec_cmd git clone -b devel https://dev.iopsys.eu/iopsys/libwifi.git libwifiutils
cd libwifiutils
exec_cmd cmake .
exec_cmd make
cd libwifiutils
exec_cmd cp wifidefs.h wifiutils.h /usr/include
exec_cmd cp -a libwifiutils.so /usr/lib


# ieee1905, map.so
cd /opt/dev
rm -fr ieee1905
exec_cmd git clone --depth 1 -b devel https://dev.iopsys.eu/iopsys/ieee1905.git
cd ieee1905
exec_cmd ./gitlab-ci/setup.sh
cd src
CFLAGS+="-DDYNAMIC_CNTLR_SYNC_CONFIG -DHAS_UBUS -DEXTENSION_ALLOWED -DEASYMESH_VERSION=6" make
mkdir -p /usr/include /usr/lib/ieee1905
exec_cmd cp -a cmdu.h /usr/include/
exec_cmd cp -a cmdu_ackq.h /usr/include/
exec_cmd cp -a 1905_tlvs.h /usr/include/
exec_cmd cp -a i1905_wsc.h /usr/include/
exec_cmd cp -a timer_impl.h /usr/include/
exec_cmd cp -a libmidgen.so /usr/lib
exec_cmd cp -a libieee1905.so /usr/lib
exec_cmd cp -a ieee1905d /usr/sbin/
exec_cmd cp -a extensions/map/libmaputil.so /usr/lib
exec_cmd cp -a extensions/map/map.so /usr/lib
exec_cmd cp -a extensions/map/map_module.h /usr/include/
exec_cmd cp -a extensions/map/cntlrsync.h /usr/include/
exec_cmd cp -a extensions/map/easymesh.h /usr/include/


# libdpp
cd /opt/dev
rm -fr libdpp
exec_cmd git clone -b devel https://dev.iopsys.eu/multi-ap/libdpp.git
cd libdpp/lib
exec_cmd make
exec_cmd cp -a libdpp*.so* /usr/lib
exec_cmd cp dpputils.h dpp_api.h dpp_sm.h json_helper.h timer.h utf8.h /usr/include


# map-controller
cd /opt/dev
rm -fr map-controller
exec_cmd git clone --depth 1 -b devel https://dev.iopsys.eu/multi-ap/map-controller.git
cd map-controller/src
CFLAGS+="-DCONTROLLER_SYNC_DYNAMIC_CNTLR_CONFIG -DEASYMESH_VERSION=6 -DUSE_LIBDPP" make
mkdir -p /usr/include/map-controller/utils
exec_cmd cp -a cntlr_apis.h /usr/include/map-controller/
exec_cmd cp -a cntlr_commands.h /usr/include/map-controller/
exec_cmd cp -a cntlr_commands_impl.h /usr/include/map-controller/
exec_cmd cp -a cntlr_plugin.h /usr/include/map-controller/
exec_cmd cp -a steer_module.h /usr/include/map-controller/
exec_cmd cp -a timer.h /usr/include/map-controller/
exec_cmd cp -a timer_impl.h /usr/include/map-controller/
exec_cmd cp -a timeutils.h /usr/include/map-controller/
exec_cmd cp -a wifi_dataelements.h /usr/include/map-controller/
exec_cmd cp -a wifi_opclass.h /usr/include/map-controller/
exec_cmd cp -a utils/debug.h /usr/include/map-controller/utils/
exec_cmd cp -a libcntlr-apis.so /usr/lib

