## Overview
This steering plugin is for Controller initiated Wi-Fi backhaul-STA steering. It functions by estimating the throughput achievable by a backhaul-STA from connecting to a neighboring (better) AP.

After a Node has onboarded via via Wi-Fi, "bsteer" plugin expects scanresults available from the new Node to be hot and valid. If the currently available scanresults cache is limited to 'zero' or 'one' entry (corresponding to the backhaul-BSS to which the Node connected), then "bsteer" plugin will trigger fresh scanning in the Node.

From the collected scanresults, the plugin filters out non-neighbors and BSSs that are not serving as backhaul-BSSs in the network.

It then proceeds to perform throughput estimations for the new Node from all neighboring (candidate) backhaul-BSSs discovered in the scanresults.



### Algorithm

The 'bsteer' plugin carries out the following steps to determine the estimated throughput of the new Node with each of the candidate neighboring backhaul-APs.
If any of the estimates is more than the Node's current throughput estimate, then the plugin will ask Controller to initiate a Backhaul Steer for the Node to that candiate backhual-AP.


**1: set bSTA's best_rate = current estimated rate**
````
st->est_rate = estimate_sta_thput(priv, s, 1);
best_rate = st->est_rate;
````

**2: get estimate of dl-throughput with neighbor backhaul-AP from rcpi of scanresults**
````
est_rate_dl = estimate_sta_thput_with_nbr(priv, s, tbss, st->scanres[i].rcpi);
````

**3: get estimate of max-throughput of the Node hosting candidate backhaul-AP**
````
tbss_est_rate_dl = cntlr_get_max_thput_estimate_for_node(cntlr, tbss->agent);
````

**4: bSTA's throughput estimate with the candiate bakchaul-AP is minimum of the above two estimates**
````
est_rate_dl = min(est_rate_dl, tbss_est_rate_dl);
````


## Configuration

In mapcontroller's config file "/etc/config/mapcontroller", add 'bsteer' as a steering plugin -

````
config sta_steering
    option enable_bsta_steer '1'
    :
    option plugins_enabled '1'
    option plugins_policy 'any'
    list plugins 'bsteer'
````

>NOTE: Ensure that the plugin `bsteer.so` is available in the mapcontroller's loadable plugin path, which is '/usr/lib/mapcontroller'.

A config section "sta-steer" may additionally be created with name 'bsteer' to hold the "bsteer" plugin specific configuration options -

````
config sta-steer 'bsteer'
	option enabled '1'		# whether 'bsteer' plugin is enabled or not
	option boost '30'		# target-AP should be better by this amount (in Mbps)
	option bandsteer '0'		# allow steering to different band when set to 1

````

The values appearing above are the default values for the config options.
