/*
 * cntlr_plugin.h - Controller plugin header file.
 *
 * Copyright (C) 2025 Genexis Sweden AB.
 *
 * Author: anjan.chanda@genexis.eu
 *
 * See LICENSE file for license related information.
 *
 */

#ifndef CNTLR_PLUGIN_H
#define CNTLR_PLUGIN_H


#include <stdint.h>
#include <stdbool.h>

#ifdef __cplusplus
extern "C" {
#endif


#define CNTLR_PLUGIN_PATH	"/usr/lib/mapcontroller"

/* controller plugin struct */
struct cntlr_plugin {
	char name[32];		/* name of the plugin */
	void *priv;		/* private (opaque) data of the plugin */
	bool enabled;

	/* callbacks from controller */
	int (*init)(void **priv);
	int (*exit)(void *priv);
	int (*process)(void *priv, void *data, uint16_t rxcmdu_type);
	int (*config)(void *priv, void *cfg);
	int (*cmdu_notifier)(void *priv, struct cmdu_buff *cmdu);

	void *handle;		/* points to dlopen()'d plugin object */
	void *controller;	/* controller context */

	/* controller received CMDUs that the plugin wants to be notified of */
	int num_cmdu;
	uint16_t *cmdulist;	/* array of cmdu types */

	struct list_head list;
};

void cntlr_load_plugins(struct controller *c);
void cntlr_unload_plugins(struct controller *c);

int cntlr_notify_plugins(struct controller *c, struct cmdu_buff *cmdu);
int cntlr_process_plugins(struct controller *c, void *data, uint16_t cmdu_type);

struct cntlr_plugin *cntlr_lookup_plugin(struct controller *c, const char *name);

#ifdef __cplusplus
}
#endif


#endif /* CNTLR_PLUGIN_H */
