/*
 * cntlr_apis.h
 * Public library header file for libcntlr-apis.so.
 *
 * Copyright (C) 2025 Genexis Sweden AB.
 *
 */

#ifndef CNTLR_APIS_H
#define CNTLR_APIS_H

#include "wifi_dataelements.h"

/* IMPORTANT -
 * APIs in the file are not stable yet and subject to change.
 * Please use them with caution from the external plugins.
 */

int cntlr_register_module(void **controller, void *module);
void cntlr_unregister_module(void *module);

struct wifi_radio_element *cntlr_get_radio_element(void *cntlr, uint8_t *ruid);
struct wifi_radio_element *cntlr_get_radio_element_by_bssid(void *cntlr, uint8_t *bssid);
struct wifi_radio_element *cntlr_get_radio_element_in_node_by_band(void *cntlr,
								   uint8_t *node_almacaddr,
								   enum wifi_band band);


struct wifi_bss_element *cntlr_get_backhaul_bss_element_in_node(void *cntlr,
								uint8_t *node_almacaddr,
								enum wifi_band band);

struct wifi_bss_element *cntlr_get_fronthaul_bss_element_in_node(void *cntlr,
								 uint8_t *node_almacaddr,
								 enum wifi_band band);

enum wifi_band cntlr_get_bss_band(void *cntlr, uint8_t *bssid);
uint8_t cntlr_get_bss_opclass(void *cntlr, uint8_t *bssid);
uint8_t cntlr_get_bss_channel(void *cntlr, uint8_t *bssid);
uint32_t cntlr_get_bss_bandwidth(void *cntlr, uint8_t *bssid);

struct wifi_sta_element *cntlr_get_sta_element(void *cntlr, uint8_t *macaddr);
void *cntlr_get_sta_steer_data(void *cntlr, uint8_t *macaddr);
bool cntlr_is_sta_bsta(void *cntlr, uint8_t *macaddr);

int cntlr_get_agent_id(void *cntlr, uint8_t *if_macaddr, uint8_t *agent_almacaddr);

/* Estimate max-throughput achievable for an EasyMesh device */
int cntlr_estimate_max_thput_for_node(void *cntlr, uint8_t *node_almacaddr);
int cntlr_get_max_thput_estimate_for_node(void *cntlr, uint8_t *node_almacaddr);

char *cntlr_get_topology_json_string(void *cntlr);

#endif /* CNTLR_APIS_H */
