/*
 * cntlr_acs.c - Auto Channel Selection header
 *
 * Copyright (C) 2021 IOPSYS Software Solutions AB. All rights reserved.
 *
 */
#ifndef CNTLR_ACS_
#define CNTLR_ACS_

#include <stdint.h>
#include <stdbool.h>

struct controller;
struct node;
struct wifi_radio_element;
struct netif_radio;
enum wifi_band;
enum wifi_radio_opclass_dfs;
struct blob_buf;

/* Alloc free private storage */
void *cntlr_radio_acs_alloc(struct controller *c, struct node *n, struct netif_radio *r);
void cntlr_radio_acs_free(void *acs);

/* Format UBUS output */
void cntlr_acs_node_info(struct node *node, enum wifi_band band, struct blob_buf *bb);
void cntlr_acs_radio_info(struct blob_buf *bb, struct netif_radio *r);
void cntlr_dfs_radio_cleanup_info(struct node *n, struct netif_radio *r, struct blob_buf *bb);
void cntlr_acs_radio_cleanup_info(struct blob_buf *bb, struct netif_radio *r);

/* CMDU info/event for ACS */
void cntlr_acs_channel_sel_response(struct netif_radio *r, uint16_t mid, uint8_t status);
void cntlr_acs_oper_channel_report(struct netif_radio *r);
void cntlr_acs_cac_completion(struct netif_radio *r, uint8_t classid,
			      uint8_t channel, uint8_t status);
void cntlr_acs_channel_pref_report(struct node *n, struct netif_radio *r);
void cntlr_acs_radio_metrics(struct node *n, struct netif_radio *r,
			     uint8_t anpi, uint8_t obss, uint8_t tx, uint8_t rx);
void cntlr_acs_scan_report(struct node *n, struct netif_radio *r, uint16_t mid);
void cntlr_acs_dev_supp_opclass(struct node *n, struct netif_radio *r);

/* Generic requests */
void cntlr_acs_recalc(struct controller *c);
void cntlr_acs_node_channel_recalc(struct node *node, enum wifi_band band,
				   uint8_t opclass, uint32_t bandwidth,
				   bool skip_dfs, bool prevent_cac,
				   bool highest_bandwidth);

void cntlr_dfs_cleanup(struct controller *c);
void cntlr_dfs_node_cleanup(struct node *node);
void cntlr_dfs_radio_cleanup(struct node *node, struct netif_radio *radio);

/* Opclass helpers */
int cntlr_radio_pref_opclass_add(struct wifi_radio_element *radio, uint8_t classid,
				 uint8_t channel, uint8_t preference);
int cntlr_radio_pref_opclass_set_dfs_status(struct wifi_radio_element *radio, uint8_t classid,
					    uint8_t channel, enum wifi_radio_opclass_dfs state);
int cntlr_radio_pref_opclass_reset(struct wifi_radio_element *radio);
void cntlr_radio_pref_opclass_dump(struct wifi_radio_element *radio);

int cntlr_radio_cur_opclass_add(struct wifi_radio_element *radio, uint8_t opclass,
				uint8_t channel, uint8_t txpower);
void cntlr_radio_cur_opclass_reset(struct wifi_radio_element *radio);
void cntlr_radio_cur_opclass_dump(struct wifi_radio_element *radio);
bool cntlr_node_pref_opclass_expired(struct node *node, int age);
void cntlr_radio_pref_opclass_set_pref(struct wifi_radio_element *radio, uint8_t id, uint8_t preference);
uint8_t ctrl_radio_cur_opclass_id(struct wifi_radio_element *radio);
uint8_t ctrl_radio_cur_opclass_ctrl_chan(struct wifi_radio_element *radio);
uint16_t ctrl_radio_cur_opclass_max_bw(struct wifi_radio_element *radio);
#endif
