import subprocess

#def exec_in_container(container_name, cmd, capture_output=True):
#    """Run a shell command inside a container."""
#    full_cmd = ["docker", "exec", container_name] + cmd
#    result = subprocess.run(full_cmd, capture_output=capture_output, text=True)
#    return result

def exec_in_container(container_name, cmd, capture_output=True):
    """ Run a shell command inside a container via socat TCP server."""
    cmd_str = " ".join(cmd)
    full_cmd = f"echo {cmd_str!r} | socat - TCP:{container_name}:6969"

    result = subprocess.run(
        full_cmd, shell=True, capture_output=capture_output, text=True
    )
    return result


def send_sighup(container_name, proc_name):
    """Send SIGHUP to a process inside a container."""
    cmd = ["sh", "-c", f"pid=$(pidof {proc_name}) && [ -n \"$pid\" ] && kill -1 $pid"]
    return exec_in_container(container_name, cmd)

