#!/bin/sh
# Generate bootup wireless config

set -e

TEMPLATE="/lib/wifi/wireless.tmpl"
OUTFILE="${OUTFILE:-/etc/config/wireless}"

if [ -z "$BANDS" ] || [ -z "$OUI" ]; then
    echo "Usage: BANDS=\"2,5,6\" OUI=\"aa:bb:cc\" wireless.sh"
    exit 1
fi

: > "$OUTFILE"

IFS=','

for BAND in $BANDS; do
    BAND_HEX=$(printf "%02x" "$BAND")
    NEWMAC="${OUI}:00:00:${BAND_HEX}"

    awk -v band="$BAND" \
        -v mac="$NEWMAC" \
    '
    {
        gsub("{{BAND}}", band);
        gsub("{{MAC}}", mac);
        print;
    }
    ' "$TEMPLATE" >> "$OUTFILE"

    echo "" >> "$OUTFILE"
done

echo "Generated wireless config at $OUTFILE:"
cat "$OUTFILE"
