# Map-controller APIs

Overview of the exposed UBUS API as well as the TR-181 DataModel Operate
commands, which interact with `map-controller`.

## UBUS API

APIs exposed over the microbus are used primarily to issue CMDU requests for
network statistics or triggering operations, such as steering or scanning.
However, APIs are additionally available to expose data to the TR-181 DataModel
and debugging, such as steering statistics and network topology information.

### API Dump
```
root@Aura-E755-943f0cbca820:~# ubus -v list map.controller
'map.controller' @b9a7b60f
	"help":{"command":"String"}
	"log":{"feature":"String","level":"Integer"}
	"status":{}
	"status_full":{}
	"timers":{}
	"query_ap_caps":{"agent":"String"}
	"query_sta_caps":{"agent":"String","sta":"String","bssid":"String"}
	"query_bsta_caps":{"agent":"String"}
	"query_ap_metrics":{"agent":"String","bsslist":"Array","radiolist":"Array"}
	"query_sta_metrics":{"agent":"String","sta":"String"}
	"query_unassoc_sta_metrics":{"agent":"String","opclass":"Integer","channel":"Integer","stalist":"Array"}
	"query_channel_pref":{"agent":"String"}
	"query_beacon_metrics":{"agent":"String","sta":"String","opclass":"Integer","channel":"Integer","bssid":"String","reporting_detail":"Integer","ssid":"String","channel_report":"Array","request_element":"Array"}
	"send_channel_sel":{"agent":"String","radioid":"String","channel":"Integer","bandwidth":"Integer"}
	"send_channel_pref":{"agent":"String","radioid":"String","band":"Integer","opclass":"Array","channel":"Array","pref":"Array"}
	"trigger_channel_clearing":{"agent":"String"}
	"trigger_acs":{"agent":"String","band":"Integer","skip_dfs":"Integer","opclass":"Integer","bandwidth":"Integer","prevent_cac":"Integer"}
	"steer":{"agent":"String","sta":"String","src_bssid":"String","target_agent":"String","target_bssid":"String","abridged":"Integer","disassoc_tmo":"Integer","mbo_reason":"Integer"}
	"steer_op":{"agent":"String","sta":"String","src_bssid":"String","abridged":"Integer","window":"Integer","disassoc_tmo":"Integer","mbo_reason":"Integer"}
	"assoc_control":{"agent":"String","bssid":"String","mode":"Integer","validity_int":"Integer","stalist":"Array"}
	"steer_backhaul":{"agent":"String","target_agent":"String","target_band":"Integer","target_bssid":"String","bsta":"String","timeout":"Integer"}
	"scan":{"agent":"String","band":"Integer","radio":"String","opclass":"Array","channel":"Array","fresh_scan":"Boolean"}
	"scanresults":{"agent":"String","band":"Integer","radio":"String"}
	"cac_start":{"agent":"String","radio":"String","opclass":"Integer","channel":"Integer","method":"Integer","action":"Integer"}
	"cac_stop":{"agent":"String","radio":"String","opclass":"Integer","channel":"Integer"}
	"send_topology_query":{"agent":"String"}
	"send_hld":{"agent":"String","protocol":"Integer","data":"String"}
	"send_combined_metrics":{"agent":"String","bssid":"String"}
	"dump_unassoc_sta_metrics":{"sta":"String"}
	"dump_beacon_metrics":{"sta":"String"}
	"dump_policy":{"agent":"String"}
	"dump_steer_summary":{"sta":"String"}
	"dump_steer_history":{"sta":"String"}
	"dump_mlo_caps":{"agent":"String"}
	"dpp_enrollee_uri":{"uri":"String","type":"String"}
	"dpp_advertise_cce":{"agent":"String","enable":"Integer"}
	"zerotouch_set_key":{"key":"String"}
	"disassociate_sta":{"agent":"String","sta":"String","reason":"Integer"}
	"reset_agent":{"agent":"String"}
	"dump_topology":{}
```

### API Table

| Method | CMDU | Description |
|--------|------|--------------|
|help | N/A | Show general usage information for `map.controller` commands |
|log | N/A | Configure logging, enable/disable feature and set verbosity level |
|status | Information gathered from a number of CMDUs | Show various statistics for each node, their radios, clients etc |
|status_full | Same as status | Same as status, however includes additional supported opclass information |
|timers | N/A | Show internal timers, primarily used for debugging |
|query_ap_caps | AP Capability Query | Trigger AP capability gathering, i.e. HT/VHT/HE caps |
|query_sta_caps | Client Capability Query | Trigger client capability gathering, i.e. client connectivity information and (re)assoc frame |
|query_bsta_caps | Backhaul STA Capability Query | Request backhaul STA capabilities |
|query_ap_metrics | AP Metrics Query | Trigger AP statistic and associated STA statistic gathering |
|query_sta_metrics | Associated STA Link Metrics Query | Request for link metrics of an associated client, i.e. throughput and RCPI |
|query_unassoc_sta_metrics | Unassociated STA Link Metrics Query | Measure signal levels and link metrics for unassociated clients |
|query_channel_pref | Channel Preference Query | Trigger query for an agent channel preferences, restrictions and CAC status |
|query_beacon_metrics | Beacon Metrics Query | Request beacon measurement reports from a client STA |
|send_channel_sel | Channel Selection Request | Instruct an agent to switch channels on a specific radio |
|send_channel_pref | Channel Preference Query | Trigger query for an agent with defined channel preferences and opclasses |
|trigger_channel_clearing | CAC Request | Initiate DFS channel clearing on an agent |
|trigger_acs | N/A | Trigger automatic channel selection (ACS) with optional DFS control |
|steer | Client Steering Request | Request to steer client to a different BSSID |
|steer_op | Steering Opportunity Request | Notify agents of a time window to perform STA steering |
|assoc_control | Client Association Control Request | Allow, block, or time-limit client (STA/bSTA) associations |
|steer_backhaul | Backhaul Steering Request | Steer a backhaul STA to a different backhaul BSSID |
|scan | Channel Scan Request | Trigger fresh scan or request cached data for a set of radio(s)/opclass/channel(s) of an agent |
|scanresults | Channel Scan Report | Show scan results gathered passively via Channel Scan Report |
|cac_start | CAC Request | Perform CAC on radio(s)/opclass/channel(s) using a provided CAC method and completion action |
|cac_stop | CAC Termination | Terminate CAC on radio(s)/opclass/channel(s) |
|send_topology_query | Topology Query | Request for network topology information |
|send_hld | Higher Layer Data | Send opaque payload over IEEE 1905 abstraction layer |
|send_combined_metrics | Combined Infrastructure Metrics | Inform agents of rx and tx link metrics over a backhaul link |
|dump_steer_summary | Client Steering BTM Report | Summary of steer statistics, i.e. attempts triggered, successfully completed and failed |
|dump_steer_history | Client Steering BTM Report  | Per station steer attempt history |
|dump_unassoc_sta_metrics | Unassociated STA Link Metric Response | Show link metrics of an unassociated client, as gathered passively via unassoc STA link metric responses |
|dump_beacon_metrics | Beacon Metrics Response | Show information passively gathered from beacon metrics responses |
|dump_policy | N/A | Display applied controller policy per agent |
|dump_mlo_caps | Wi-Fi 7 Agent Capabilities | Display Multi-Link Operation capability information from agents |
|dpp_enrollee_uri | N/A | Provide DPP Enrollee QR Code |
|dpp_advertise_cce | DPP CCE Indication | Inform agent to enable/disable CCE advertisement in beacons and probe responses |
|zerotouch_set_key | N/A | Configure Wi-Fi key used in zero-touch DPP onboarding |
|disassociate_sta | Vendor Specific | Command an agent to forcibly disconnect a client STA |
|reset_agent | Vendor Specific | Reboot or reset the Multi-AP stack on a target agent |
|dump_topology | 1905 Topology Response | Display hierarchical Multi-AP network structure |


## TR-181 DataModel API

TR-181 DataModel interacts with map-controller via either its UBUS API or UCI.

### TR-181 Dump

```
Device.WiFi.DataElements.Network.Device.{i}.MultiAPDevice.Backhaul.SteerWiFiBackhaul()
Device.WiFi.DataElements.Network.Device.{i}.MultiAPDevice.Backhaul.SteerWiFiBackhaul() input:TargetBSS
Device.WiFi.DataElements.Network.Device.{i}.MultiAPDevice.Backhaul.SteerWiFiBackhaul() input:TimeOut
Device.WiFi.DataElements.Network.Device.{i}.MultiAPDevice.Backhaul.SteerWiFiBackhaul() output:Status
Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.BSS.{i}.STA.{i}.ClientSteer()
Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.BSS.{i}.STA.{i}.ClientSteer() input:BTMAbridged
Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.BSS.{i}.STA.{i}.ClientSteer() input:BTMDisassociationTimer
Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.BSS.{i}.STA.{i}.ClientSteer() input:TargetBSSID
Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.BSS.{i}.STA.{i}.ClientSteer() output:Status
Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.ChannelScanRequest()
Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.ChannelScanRequest() input:ChannelList
Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.ChannelScanRequest() input:OpClass
Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.ChannelScanRequest() output:Status
Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.ChannelSelectionRequest()
Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.ChannelSelectionRequest() input:Class.{i}.Channel.{i}.Channel
Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.ChannelSelectionRequest() input:Class.{i}.Channel.{i}.Preference
Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.ChannelSelectionRequest() input:Class.{i}.OpClass
Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.ChannelSelectionRequest() output:Status
Device.WiFi.DataElements.Network.Device.{i}.RefreshAPMetrics()
Device.WiFi.DataElements.Network.Device.{i}.RefreshAPMetrics() input:RUID
Device.WiFi.DataElements.Network.Device.{i}.RefreshAPMetrics() output:Status
Device.WiFi.DataElements.Network.Device.{i}.SetSTASteeringState()
Device.WiFi.DataElements.Network.Device.{i}.SetSTASteeringState() input:Disallowed
Device.WiFi.DataElements.Network.Device.{i}.SetSTASteeringState() output:Status
Device.WiFi.DataElements.Network.SetSSID()
Device.WiFi.DataElements.Network.SetSSID() input:AKMsAllowed
Device.WiFi.DataElements.Network.SetSSID() input:AddRemoveChange
Device.WiFi.DataElements.Network.SetSSID() input:Band
Device.WiFi.DataElements.Network.SetSSID() input:Enable
Device.WiFi.DataElements.Network.SetSSID() input:HaulType
Device.WiFi.DataElements.Network.SetSSID() input:PassPhrase
Device.WiFi.DataElements.Network.SetSSID() input:SSID
Device.WiFi.DataElements.Network.SetSSID() input:Type
Device.WiFi.DataElements.Network.SetSSID() input:X_IOWRT_EU_EnableMLD
Device.WiFi.DataElements.Network.SetSSID() input:X_IOWRT_EU_NewSSID
Device.WiFi.DataElements.Network.SetSSID() input:X_IOWRT_EU_TrafficSeparation
Device.WiFi.DataElements.Network.SetSSID() output:Status
Device.WiFi.DataElements.Network.SetTrafficSeparation()
Device.WiFi.DataElements.Network.SetTrafficSeparation() input:Enable
Device.WiFi.DataElements.Network.SetTrafficSeparation() input:SSIDtoVIDMapping.{i}.SSID
Device.WiFi.DataElements.Network.SetTrafficSeparation() input:SSIDtoVIDMapping.{i}.VID
Device.WiFi.DataElements.Network.SetTrafficSeparation() output:Status
```


### API Table

| Object  		                                                    | API  | CMDU | Description	|
|---------------------------------------------------------------------------|------|------|-------------|
|Device.WiFi.DataElements.Network.Device.{i}.MultiAPDevice.Backhaul.SteerWiFiBackhaul() | UBUS | Backhaul Steering Request | ubus call map.controller steer_backhaul |
|Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.BSS.{i}.STA.{i}.ClientSteer() | UBUS | Client Steering Request | ubus call map.controller steer |
|Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.ChannelScanRequest() | UBUS | Channel Scan Request | ubus call map.controller scan |
|Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.ChannelSelectionRequest() | UBUS | Channel Preference Request | ubus call map.controller send_channel_pref |
|Device.WiFi.DataElements.Network.Device.{i}.RefreshAPMetrics() | UBUS | AP Metrics Query | ubus call map.controller query_ap_metrics |
|Device.WiFi.DataElements.Network.Device.{i}.SetSTASteeringState() | UCI | STA Steering State | Set steer_disallow per 'node' section |
|Device.WiFi.DataElements.Network.SetSSID() | UCI | AP-Autoconfiguration Renew, AP-Autoconfiguration WSC | Set SSID, key etc. per 'ap' section |
|Device.WiFi.DataElements.Network.SetTrafficSeparation() | UCI | Multi-AP Policy Config Request | Enable, disable (via 'controller' section) or set SSID-to-VID mapping (via 'ap' sections) |
