/*
 * steer.h - steering functions.
 *
 * Copyright (C) 2022 IOPSYS Software Solutions AB. All rights reserved.
 *
 * Author: anjan.chanda@iopsys.eu
 *
 * See LICENSE file for license related information.
 *
 */

#ifndef STEER_H
#define STEER_H

#include <stdint.h>

#include "timer_impl.h"

enum steer_trigger;
struct controller;
struct sta;


void cntlr_check_usta_steer(struct controller *c, struct sta *s);

struct wifi_steer_history *sta_lookup_steer_attempt(struct sta *s, uint8_t *src, uint8_t *dst);
void cntlr_update_sta_steer_counters(struct controller *c,
				     uint8_t *sta_mac,
				     uint8_t *src_bssid,
				     uint8_t *dst_bssid,
				     uint32_t mode,
				     enum steer_trigger trigger,
				     uint8_t dst_rcpi);
void cntlr_notify_client_steer_req_evt(struct controller *c,
			uint8_t *bssid, uint32_t sta_nr, uint8_t stas[][6],
			uint32_t bssid_nr, uint8_t target_bssid[][6]);
void cntlr_notify_client_steer_result(struct controller *c,
		uint8_t *sta_mac, int result);
void cntlr_btm_req_timer_cb(atimer_t *t);
void cntlr_notify_backhaul_steer_req_evt(struct controller *c, uint8_t *agent,
		uint8_t *bsta, uint8_t *tbssid, uint8_t opclass, uint8_t channel);

int cntlr_steer_sta(struct controller *c, struct sta *s, uint8_t *target_bssid,
		    uint32_t mode, uint32_t reason);
int cntlr_steer_bsta(struct controller *c, uint8_t *bsta,
		     uint8_t *tbssid, uint8_t opclass, uint8_t channel);

void cntlr_update_sta_steer_data(struct controller *c, struct sta *s);
void cntlr_inform_bsteer_modules(struct controller *c, struct sta *s, uint16_t rxcmdu_type);
void cntlr_inform_steer_modules(struct controller *c, struct sta *s, uint16_t rxcmdu_type);

#endif /* STEER_H */
