#ifndef CNTLR_EXTENSION_H
#define CNTLR_EXTENSION_H

#ifdef EASYMESH_VENDOR_EXT
#include <1905_tlvs.h>

#ifndef EASYMESH_VENDOR_EXT_OUI_DEFAULT
#define EASYMESH_VENDOR_EXT_OUI_DEFAULT		0xB456FA  /* IOPSYS OUI */
#endif

/* Vendor TLV types supported by our implementation */
enum tlv_vendor_type_impl {
	TLV_VENDOR_TYPE_IMPL_UNSPEC = 0,
	TLV_VENDOR_TYPE_IMPL_PROBE_REQ = 1, /* Probe Requests */
	TLV_VENDOR_TYPE_IMPL_DISASSOCIATE_STA = 2, /* Disassociate STA */
	TLV_VENDOR_TYPE_IMPL_RESET_AGENT = 3, /* Reset agent's MultiAP stack */
};

/* Vendor TLV structure for our implementation */
struct tlv_vendor_impl {
	struct tlv_vendor_specific vendor;
	uint8_t vendor_type; /* Belongs to tlv_vendor_type_impl enumeration */
} __attribute__((packed));

struct tlv_vendor_disassociate_sta {
	struct tlv_vendor_impl vendor_impl;
	uint8_t macaddr[6];
	uint16_t reason;
} __attribute__((packed));

struct tlv_vendor_probe_req {
	struct tlv_vendor_impl vendor_impl;
	uint8_t macaddr[6];
	uint8_t bssid[6];
	uint8_t rcpi;
} __attribute__((packed));

struct tlv_vendor_reset_agent {
	struct tlv_vendor_impl vendor_impl;
} __attribute__((packed));

#ifdef PROPAGATE_PROBE_REQ
int handle_vendor_specific_probe_req(void *cntlr, struct cmdu_buff *rx_cmdu,
		struct tlv_vendor_probe_req *tlv);
#endif

int handle_vendor_extension(void *cntlr, struct cmdu_buff *rx_cmdu, struct node *n);
int cntlr_gen_vendor_specific_disassociate_sta_tlv(struct controller *c,
		struct cmdu_buff *frm, uint8_t *sta, uint16_t reason);
int cntlr_gen_vendor_specific_reset_agent_tlv(struct controller *c, struct cmdu_buff *frm);
struct cmdu_buff *cntlr_gen_vendor_specific_disassociate_sta(struct controller *c,
		uint8_t *sta, uint16_t reason);
struct cmdu_buff *cntlr_gen_vendor_specific_reset_agent(struct controller *c);
#endif

#endif /* CNTLR_EXTENSION_H */ 
