#!/bin/bash
set -e
echo "compile features"

pwd

cd src/

for v in ${1:-2 3 4 5 6}; do {
	cflags="-I/usr/include/libnl3 -Werror -Wall -DCONTROLLER_SYNC_DYNAMIC_CNTLR_CONFIG -Wno-deprecated-declarations -DEASYMESH_VERSION=$v"

	if (( v > 2 )); then
		cflags+=" -DUSE_LIBDPP"
	fi

	CFLAGS="$cflags" make;
	CFLAGS="$cflags" make clean;
}; done
