# MAP Controller

[Map-Controller](https://dev.iopsys.eu/iopsys/map-controller)


## Introduction

This package provides **mapcontroller** - an EasyMesh Controller conforming to the Wi-Fi Alliance Easymesh Specification 6.0.

## Overview

The README briefly describes the salient features supported by mapcontroller, and walk-through the configuration options that are available to them.

## Features:

* Onboarding and AP autoconfiguration
* Network Policy Configuration
* Wi-Fi 7 and MLO configuration
* AP Configuration change
* Network Channel Planning
* STA Steering
* VLAN + Layer2 Traffic Separation
* QoS and Service Prioritization
* Controller Automatic Startup/Stop
* Vendor Extensions
* Vendor Extensions (IOWRT specific)

## AP autoconfiguration

For a detailed view of the available map-controller UCI configuration options,
see [UCI docs](https://dev.iopsys.eu/multi-ap/map-controller/-/blob/devel/docs/api/mapcontroller.md?ref_type=heads).


**Example-1** shows a sample Controller configuration file.
The 'ap' sections correspond to the AP configuration parameters for the Wi-Fi bands that
the Controller can provison an EasyMesh Agent with, during the Onboarding and
AP-autoconfiguration stage.

```
mapcontroller UCI config
------------------------

config controller 'controller'
	option enabled '1'
	option registrar '6 5 2'
	option primary_vid '1'
	option enable_ts '0'
	option primary_pcp '0'
    :
    .

config sta_steering
	option enable_sta_steer '1'
	option enable_bsta_steer '0'
    :

# fronthaul AP on 6GHz radio.
config ap
	option band '6'
	option ssid 'fAP-021000000001'
	option encryption 'sae'
	option key 'password'
	option vid '1'
	option type 'fronthaul'

# fronthaul AP on 5GHz radio.
config ap
	option band '5'
	option ssid 'fAP-021000000001'
	option encryption 'sae-mixed'
	option key 'password'
	option vid '1'
	option type 'fronthaul'

# fronthaul AP on 2.4GHz radio.
config ap
	option band '2'
	option ssid 'fAP-021000000001'
	option encryption 'sae-mixed'
	option key 'password'
	option vid '1'
	option type 'fronthaul'

# backhaul AP on 6GHz radio.
config ap
	option band '6'
	option ssid 'MAP-021000000001-BH'
	option encryption 'sae'
	option type 'backhaul'
	option vid '1'
	option key '569dfdc9447e494da231d4def3441ed92c8f63985d8992cb521d77e1763c00d'

# backhaul AP on 5GHz radio.
config ap
	option band '5'
	option ssid 'MAP-021000000001-BH'
	option encryption 'sae'
	option type 'backhaul'
	option vid '1'
	option key '569dfdc9447e494da231d4def3441ed92c8f63985d8992cb521d77e1763c00d'

# backhaul AP on 5GHz radio.
config ap
	option band '2'
	option ssid 'MAP-021000000001-BH'
	option encryption 'sae'
	option type 'backhaul'
	list disallow_bsta '0'
	option vid '1'
	option key '569dfdc9447e494da231d4def3441ed92c8f63985d8992cb521d77e1763c00d'
```
*Example-1: A sample configuration showing fronthaul and backhaul AP configurations that are available for provisioning to EasyMesh Agents.*


### Fronthaul side AP configuration

A fronthaul 'ap' config section is identified by the option `type 'fronthaul'`.

>NOTE: In Openwrt based systems, the 'wifi-iface' sections within the 'wireless'
> UCI config file can have the `option multi_ap` to indicate fronthaul and/or
> backhaul interface type of the Multi-AP network.
>
> `option multi_ap '2'`    # for fronthaul side.
>
> `option multi_ap '1'`    # for backhaul side.

**Example-2** below shows how the 'ap' sections (from Example-1 above) can get
mapped to the 'wifi-iface' sections in Openwrt's wireless UCI config file.

```
wireless UCI config
-------------------

config wifi-iface 'default_wl0'
	option device 'wl0'
	option network 'lan'
	option ifname 'wl0'
	option mode 'ap'
	option multi_ap '2'
	option ssid 'fAP-021000000001'
	option key 'password'
	option encryption 'sae-mixed'
	option ieee80211w '1'
	option multi_ap_backhaul_ssid 'MAP-021000000001-BH'
	option multi_ap_backhaul_key '569dfdc9447e494da231d4def3441ed92c8f63985d8992cb521d77e1763c00d'
    :
    .

config wifi-iface 'default_wl1'
	option device 'wl1'
	option network 'lan'
	option ifname 'wl1'
	option mode 'ap'
	option multi_ap '2'
	option ssid 'fAP-021000000001'
	option key 'password'
	option encryption 'sae-mixed'
	option ieee80211w '1'
	option multi_ap_backhaul_ssid 'MAP-021000000001-BH'
	option multi_ap_backhaul_key '569dfdc9447e494da231d4def3441ed92c8f63985d8992cb521d77e1763c00d'
    :
    .
```
*Example-2: Openwrt's wireless UCI showing EasyMesh fronthaul APs configuration*

### Backhaul side AP configuration

The config 'ap' sections with  `option type 'backhaul'` holds the Backhaul
side APs' configuration. Just like the fronthaul 'ap' sections described above,
during Onboarding, an EasyMesh Agent running in Openwrt based system is expected to create the 'wifi-iface'
sections appropriately in the 'wireless' UCI file, with `option multi_ap '1'`.

In an Multi-AP network, the Backhaul APs serve as the Wi-Fi Backhaul to other
EasyMesh Agent devices that have Wi-Fi STAs for connection establishment.

**Example-3** shows how the Controller's 'ap' sections for backhaul APs can be
mapped to the 'wifi-iface' sections by an EasyMesh Agent in Openwrt based system.

```
'mapcontroller' UCI config
--------------------------

config ap
	option band '2'
	option ssid 'MAP-021000000001-BH'
	option encryption 'sae'
	option key '569dfdc9447e494da231d4def3441ed92c8f63985d8992cb521d77e1763c00d'
	option vid '1'
	option type 'backhaul'

config ap
	option band '5'
	option ssid 'MAP-021000000001-BH'
	option encryption 'sae'
	option type 'backhaul'
	option vid '1'
	option key '569dfdc9447e494da231d4def3441ed92c8f63985d8992cb521d77e1763c00d'

        |
        |
        V

'wireless' UCI config
---------------------

config wifi-iface 'default_wl1_1'
	option device 'wl1'
	option mode 'ap'
	option ifname 'wl1.1'
	option multi_ap '1'
	option network 'lan'
	option hidden '1'
	option ssid 'MAP-021000000001-BH'
	option key '569dfdc9447e494da231d4def3441ed92c8f63985d8992cb521d77e1763c00d'
	option encryption 'sae'
	option ieee80211w '2'
    :

config wifi-iface 'default_wl0_1'
	option device 'wl0'
	option mode 'ap'
	option ifname 'wl0.1'
	option multi_ap '1'
	option network 'lan'
	option hidden '1'
	option ssid 'MAP-021000000001-BH'
	option key '569dfdc9447e494da231d4def3441ed92c8f63985d8992cb521d77e1763c00d'
	option encryption 'sae'
	option ieee80211w '2'
    :

```
*Example-3: Backhaul 'ap' sections from mapcontroller to 'wifi-iface' sections in wireless config.*

### Combined (Fronthaul + Backhaul) AP configuration

If fronthaul and backhaul AP are to be configured on a single AP interface, then
the 'ap' section must have option `type 'combined'` included in it.

```
config ap
	option band '2'
	option ssid 'AP-021000000001'
	option encryption 'sae-mixed'
	option key '7NTx-APvX-pba7-tvd7'
	option vid '1'
	option type 'combined'
```
*Example-4: mapcontroller config 'ap' section for Combined AP configuration*

From above **Example-4** config, an EasyMesh Agent running in Openwrt based system
is expected to create the following 'wifi-iface' section for Combined AP interface as below -

```
config wifi-iface 'default_wl0'
	option device 'wl0'
	option network 'lan'
	option ifname 'wl0'
	option mode 'ap'
	option wps '1'
	option wps_pushbutton '1'
	option ieee80211k '1'
	option bss_transition '1'
	option uuid 'c8f1402f-1ef9-4801-9a68-021000000001'
	option multi_ap '3'                     # for serving as fronthaul+backhaul
	option ssid 'AP-021000000001'
	option key '7NTx-APvX-pba7-tvd7'
	option encryption 'sae-mixed+aes'
	option ieee80211w '1'
	option start_disabled '0'
	option multicast_to_unicast '1'
	option isolate '0'
```
*Example-5: The 'wifi-iface' section showing a Combined (Fronthaul+Backhaul) AP*

> NOTE: The `multi_ap '3'` option in wireless UCI config indicates a Combined AP interface.


### Multi-AP network Policy Configuration

The Controller uses 'Multi-AP Policy Configuration Request' to configure EasyMesh Agents in the Multi-AP network.
The policy configuration parameters available to the Controller are as defined in the EasyMesh standard.

The Controller however decides when and what policy parameters to configure based on intelligence built-into it.
Examples of policy parameters include - 1) allow or disallow STA-steering, 2) report AP
and STA metrics and at what frequency, 3) Primary VLAN ID and default PCP when
Traffic Separation and Guest Wi-Fi is enabled, 4) report unsuccessful STA
association attempts in the network, to name a few.

All Multi-AP Policy Configuration parameters described in Section 7.3 and 17.1.8
of the Wi-Fi EasyMesh specification 6.0 is supported.

#### EasyMesh Agent Specific Policy Configuration

Whenever the Controller discovers an EasyMesh Agent (through 'AP-Autoconfiguration Search' messages),
it adds a corresponding 'node' section in the mapcontroller config file.

```
mapcontroller UCI config
------------------------

config node 'node_ee6c9a52b027'
	option agent_id 'ee:6c:9a:52:b0:27'

    # the following options are not set explicitly. Instead their default values are used.
	option backhaul_ul_macaddr '00:00:00:00:00:00'
	option backhaul_dl_macaddr '00:00:00:00:00:00'
	option backhaul_type 'none'
	option primary_vid '1'
	option primary_pcp '0'
	option report_sta_assocfails '0'
	option report_sta_assocfails_rate '0'
	option report_metric_periodic '0'
	option report_scan '0'
	list steer_exclude ''
	list steer_exclude_btm ''
	option steer_disallow '0'
	option coordinated_cac '0'
	option traffic_separation '0'
	option sta_steer '0'
```
*Example-6: A 'node' config section corresponding to the EasyMesh Agent EE:6C:9A:52:B0:27*

If user changes the value for any of the options, the configuration can be reloaded
by either sending a signal (`SIGHUP`) to the running mapcontroller process or by
calling the UBUS API `ubus call map.controller reconf`. This causes mapcontroller
to re-read the config file and take appropriate actions.

#### EasyMesh Agents' Radio Specific Policy Configuration

Again, when an EasyMesh agent is discovered, Controller proceeds to complete
Onboarding and AP-Autoconfiguration.

During the AP-Autoconfiguration step, the Agent sends WSC (M1) message for each
available radio in the Agent that it wants to be configured.
For each such configured radio, Controller creates new 'radio' sections in the
mapcontroller config file. The policy configuration applicable on per-radio
basis in the Agents reside in these sections.

```
mapcontroller UCI config
------------------------

config radio 'radio_ec6c9a52acb9'
	option agent_id 'ee:6c:9a:52:ac:b7'
	option macaddr 'ec:6c:9a:52:ac:b9'
	option band '5'

    # Following options are not set explicitly. Instead, their default values are used.
	option steer_policy '0'
	option util_threshold '0'
	option rcpi_threshold '86'
	option report_rcpi_threshold '96'
	option report_util_threshold '0'
	option report_rcpi_hysteresis_margin '0'
	option include_sta_stats '1'
	option include_sta_metric '1'
```
*Example-7: A 'radio' section for the Wi-Fi Radio interface in the EasyMesh Agent EE:6C:9A:52:B0:27*

Just like above, if user changes any of the option values in the section, then
the configuration should be reloaded either by sending a signal (`SIGHUP`) or
by calling `ubus call map.controller reconf` for the changes to take effect.

### Wi-Fi 7 and MLO configutaion

If an EasyMesh Agent indicates Wi-Fi 7 and MLO capability during the Onboarding
stage via the 'Early AP Capability Report' messages, then the Controller
will provide the MLD interface configuration to the Agent through the
'Agent AP MLD Configuration TLVs' and 'Backhaul STA MLD Configuration TLVs'.

To provision MLD interfaces, the `mld` sections in the mapcontroller config
hold the corresponding configuration parameters f.e. ssid, key, type etc.

```
mapcontroller UCI config
------------------------

config mld
	option id '1'
	option ssid 'fMLDAP-SSID'
	option key 'password'
	option type 'fronthaul'

    # To associate an 'ap' to the MLD (id = 1) above, the `mld_id` field within
    # the 'ap' section must match the `id` field of the 'mld' section.

config ap
	option band '2'
	option ssid 'fMLDAP-SSID'
	option encryption 'sae-mixed'
	option key 'password'
	option vid '1'
	option type 'fronthaul'
	option mld_id '1'

```
*Example-8: MLD AP config alongwith one of its affiliated 'ap' config*

During the AP-autoconfiguration step, all `ap` sections that belong to a MLD
will have their SSIDs and key values propagated to the EasyMesh Agents
alongwith the corresponding MLD configuration.

>IMPORTANT: If the 'encryption' option in `mld` section is not provided,
> then the 'encryption' option within the associated `ap` sections will
> not be overwritten. It is expected that that specific 'ap' will use the
> encryption as supplied in the `ap` section.

> NOTE: If an EasyMesh Agent does not support Wi-Fi 7 and MLO, then Controller
> will provision it with SLO APs like legacy AP-autoconfiguration.


## AP Configuration change in the Multi-AP network

If user wants to change the Multi-AP network configuration, he/she updates the
mapcontroller config file appropriately and triggers a configuration reload either
by sending a signal (SIGHUP) or by calling `ubus call map.controller reconf`.

The Controller re-reads the config, compare the changes with the current configuration
and sends '1905 AP-Autoconfiguration Renew' messages to all EasyMesh Agents in
the Multi-AP network for reconfiguration.

## Channel Planning

Map-controller supports channel planning in the form of channel selection, and
background CAC (if supported) to clear channels. Each locked behind their own
UCI configuration options.

Additionally, there are ubus methods available to do it manually:

* ubus call map.controller scan '{"agent":"46:d4:37:71:be:80", "radio":["44:d4:37:71:be:8f"], "channel":[[]]}' - best call before channel_pref – to get fresh preference counters
* ubus call map.controller channel_pref – get/update channel preferences from all nodes
* ubus call map.controller channel_cleanup – run background CAC (preCAC) on nodes if required
* ubus call map.controller channel_recalc – base on channel preference score choose best channel for each node and radio and request node to switch to this channel

### Channel Selection

Map-controller will send a Channel Preference Query to its agents and collect
the results. Whenever the channel selection periodic timer is hit,
map-controller will calculate the best channel for the network.

This feature is enabled by the UCI configuration:
```
config controller 'controller'
	option channel_plan '0'
```

The `channel_plan` value corresponds to the timeout in seconds at which channel
planning will be triggered. Any value less than 180 will be treated as invalid
and default to 3600 * 3 seconds (three hours). Setting to 0 means disabled.

Do note that this feature will not kick in for any radio which has a downstream
agent wirelessly connected.

### Background DFS

If enabled, map-controller will periodically trigger background dfs in each
agent that supports it, based on bandwidth, channel and DFS availability.

This feature is enabled by the UCI configuration:
```
config controller 'controller'
	option allow_bgdfs '0'
```

The `allow_bgdfs` value corresponds to the timeout in seconds at which
background DFS will be triggered. Any value less than 120 will be treated as
invalid and default to 120 seconds (two minutes). Setting to 0 means disabled.


## STA Steering

Controller initiated STA steering is supported through the steering plugins,
which can be dynamically loaded, unloaded, enabled or disabled.

An example STA steering plugin is the '**rcpi**' plugin (`/usr/lib/mapcontroller/rcpi.so`),
which makes the steering decision based on a STA's latest uplink and/or downlink RCPI measurements.

The 'rcpi' plugin uses the standard EasyMesh messages -
*Unassociated STA Link Metrics Query*, *Unassociated STA Link Metrics Response*,
*Beacon Metrics Query* and *Beacon Metrics Response*, to decide a suitable target
AP from the available neighbor APs of the EasyMesh network.

Once a suitable target-AP is identified, 'rcpi' plugin informs the Controller,
which then sends a 'Client Steering Request' EasyMesh message to the STA's Agent
node to steer the STA to the target-AP.

The following section in 'mapcontroller' config holds the STA steering related
configuration options -

```
config sta_steering
	option enable_sta_steer '1'
	option report_rcpi_threshold_2g '80'
	option report_rcpi_threshold_5g '96'
	option report_rcpi_threshold_6g '96'
	option plugins_policy 'any'           # how steering decisions from multiple plugins are clubbed together
	list plugins 'rcpi'                   # steering plugin name
```

Aditionally, the config options below are available on a per-radio basis -

```
config radio 'radio_44d4376af4cf'            
        option agent_id '46:d4:37:6a:f4:c0'  
        option macaddr '44:d4:37:6a:f4:cf'   
        option band '5'
        option rcpi_threshold '86'
        option report_rcpi_threshold '96'
```

The default values of the RCPI threshold for 2.4, 5 and 6 GHz bands are
respectively as following -

> option rcpi_threshold_2g '70'
>
> option rcpi_threshold_5g '86'
>
> option rcpi_threshold_6g '86'

### STA Steering Exclude lists

STAs can be excluded from steering by adding their macaddresses in the following lists -

- `steer_exclude` (can be configured per Agent node) – to exclude STAs from steering completely;
- `steer_exclude_btm` (also configurable per Agent node) – to exclude STAs from steering using 802.11v BTM Request.

Example below shows how few STAs can be excluded from steering -

```
config node 'node_46d4376af4c0'       
        option agent_id '46:d4:37:6a:f4:c0'      
        list steer_exclude 'e0:d4:e8:79:c4:ee'   
        list steer_exclude 'e0:d4:e8:79:c4:11'   
        list steer_exclude_btm 'aa:bb:cc:dd:ee:ff'
```

## Dynamic Controller Sync

In a mesh where the controller node may change and taken by any device in the
network, it is important to keep all mapcontroller configs in-sync. If not, the
credentials, polices etc. may change upon a new device taking the controller
role resulting in disruption for the clients in the network. While the logic for
this primarily resides in the map-agent, it does have to be compile-time
selected into mapcontroller in order for it to be supported.

This compile-time flag for map-controller is
`CONTROLLER_SYNC_DYNAMIC_CNTLR_CONFIG`.

Additionally, in ieee1905 and map-agent:
* map-agent - `AGENT_SYNC_DYNAMIC_CNTLR_CONFIG`
* ieee1905 - `MULTIAP_DYNAMIC_CNTLR_SYNC_CONFIG`

## Traffic Separation

For a more in-depth README on Traffic Separation see [link](https://dev.iopsys.eu/iopsys/map-agent/-/blob/devel/docs/README-Traffic_Separation.md).
For instructions on how to setup layer 3 Traffic Separation, see [link](https://dev.iopsys.eu/iopsys/map-agent/-/blob/devel/docs/README-Layer3ts.md).

To enable Guest WiFi and Easymesh Traffic Segregation, the option 'primary_vid'
and 'enable_ts' must be set to a non-zero value in the map-controller config's
global section.


```
config controller 'controller'
	option enabled '1'
	option registrar '5 2'
	option primary_vid '1'
	option primary_pcp '0'
	option enable_ts '1'
```

To create a Guest WiFi network, a new 'ap' configuration section must be added
to the map-controller configuration, with a VID different from the primary.
Alternatively, an existing section may have its VID changed.

```
config ap
	option band '5'
	option ssid 'iopsysWrt-GUEST-5'
	option encryption 'sae-mixed'
	option key '1234567890'
	option vid '10'
	option type 'fronthaul'
```

After changing as above, reload the configuration by either issuing a `SIGHUP` signal
or calling `ubus call map.controller reconf` in order to reload the new configuration
and propagate the changes to the map-agents in the Multi-AP network.


### QoS (Service Prioritization)

Service Prioritization feature allows setting packet priorities which can be
used by the switches and WiFi access points on the traffic path to accelerate
properly marked packet types.

The configuration of this features boils down to enabling QoS generally and
adding rules. Controller would propagate these rules to agents by sending
Service Prioritization Requests, and then it is up to agents to decide whether
it is possible to enable them or not.

For now, the only supported rule type is `dscp_pcp`, which allows mapping up to
64 Differentiated Services Code Point (DSCP, `[0, 63]`) values to 8 Priority
Call Point (PCP, `[0, 7]`) values. The sample configuration is provided below.

```
config qos 'qos'
	option enabled '1'

config qos_rule 'qos_rule1'
	option id '0'
	option enabled '1'
	option precedence '200'
	option type 'dscp_pcp'
	option output '8'
	option always_match '1'
	list dscp_pcp '58,1'
	list dscp_pcp '10-21,5'
```

The `precedence` is used to specify the priority of the rule. If it is not
defined, it is set to 254, which represents the highest priority, since
255 is reserved.

The `output` value determines the target PCP. If the rule has `output`
less than `8`, a PCP value of that range (`[0, 7]`) would be used as a target
for all possible DSCP values. The value outside the `[0, 8]` range would be
considered malformed and would trigger errors.

The `always_match` flag is assumed for `dscp_pcp` type because rule matching is
provided through TCLAS objects, which are not available for configuring for
that rule type.

The `dscp_pcp` is a comma-separated array of up to 64 integers in `[0, 7]`
range. Each integer designates a PCP value which would be used for packets with
the DSCP value corresponding to the index of the said PCP value.

Note that DSCP/PCP mapping table can't be completely sparse in terms of used
values and has to be made with care. Technically, the agent would have to
convert this table to the list of PCP/DSCP ranges (8 ``[dscp_min, dscp_max]``
ranges) and up to 21 DSCP exceptions (``[DSCP, PCP]``), which means there can be
no precise conversion between original DSCP/PCP mapping table and the final map.
Agent will do its best to generate a proper map, but will not inform controller
about the possible imprecision.

The support of the feature on the agent depends on the used WiFi driver. The
agent passes the generated map directly to the driver, and it is up to driver
to decide whether to activate it or not.



## Dynamic Vendor Extensions

UCI configurable vendor extensions can be passed by the map-controller within
the AP-Autoconfiguration WSC M2 frame to its agents.

These vendor extensions are UCI configurable by `list vendor_ie <hex string>`, from the
map-controller AP section in the format of:

```
section ap
	option band '5'
	option ssid 'iopsysWrt-021000000001'
	option encryption 'sae-mixed'
	option key '7NTx-APvX-pba7-tvd7'
	option vid '1'
	option type 'fronthaul'
	list vendor_ie '<oui><data>'   # oui must be 3 bytes
```


Values that are not provided as full bytes (i.e. not even number of characters)
are discarded.

Each vendor_ie will be appended with Vendor Extension attribute ID 0x1049 in the
WSC M2 payload. When received by map-agent, they will be parsed and added to the
respective ap section in the same format.

Example configuration -
From the map-controller AP section:

```
config ap
      option band '5'
      option ssid 'iopsysWrt-021000000001'
      option encryption 'sae-mixed'
      option key '7NTx-APvX-pba7-tvd7'
      option vid '1'
      option type 'fronthaul'
      list vendor_ie '00112211'
```

As seen added to map-agent AP sections:

```
config ap
      option ifname 'wl0'
      option band '5'
      option device 'wl0'
      option type 'fronthaul'
      option encryption 'sae-mixed+aes'
      option vid '1'
      option ssid 'iopsysWrt-021000000001'
      option key '7NTx-APvX-pba7-tvd7'
      option enabled '1'
      list vendor_ie '00112211'            # custom vendor extension
```
## Vendor Extensions

The Controller supports few vendor extensions out-of-box in default
configuration. All vendor extensions are guarded with the compile-time flag
`EASYMESH_VENDOR_EXT`.

The vendor OUI can be passed at compile-time through the `EASYMESH_VENDOR_EXT_OUI` option.
If EASYMESH_VENDOR_EXT_OUI is enabled but no vendor OUI is provided, then the OUI defaults to 0x001122.

### Enabled SSID

Under an `ap` section there is an `enabled` option, which has different behavor
when vendor extensions are compiled and not.

```
config ap
	option band '5'
	option ssid 'iopsysWrt-44D43771BB20'
	option encryption 'sae-mixed'
	option key '1234567890'
	option vid '1'
	option type 'fronthaul'
	option enabled '0'
```

When `EASYMESH_VENDOR_EXT` is compiled in, the 'ap' section (as above) will be
propagated within an AP-Autoconfig WSC CMDU. A wsc vendor attribute gets
included inside the WSC-M2 TLV (with a custom attribute 0x4c), which carries
this 'enabled=0' information.

If the receiving map-agent also has EASYMESH_VENDOR_EXT enabled and compiled in,
this 'ap' section received through the AP-autoconfiguration will have disabled =
'true' set when written to the 'wireless' and corresponding 'hostapd'
configuration.

If `EASYMESH_VENDOR_EXT` is not included (*default*), map-controller will skip
this 'ap' section entirely, and the section will not be included in any
AP-Autoconfiguration WSC-M2 TLVs.

### Backhaul BSS Identifying

To easily identify a backhaul BSS, a vendor extension TLV is optionally added to
Topology Response CMDUs and parsed by map-controller. This is merely a cosmetic
improvement in the map-controller `status` UBUS API.

## DPP Easy Connect


DPP onboarding is implemented using [libdpp](https://dev.iopsys.eu/multi-ap/libdpp).

No additional configuration sections are needed, but map-controller must be
compiled with the CLFAGS including `USE_LIBDPP`.

### Wi-Fi
To perform DPP Easy Connect, the enrollees bootstrap information must provided
to the map-controller via its UBUS API:

```
ubus call map.controller dpp_enrollee_uri '{"uri":"DPP:C:81\/1,115\/36;V:2;K:MDkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDIgADpRfiMElpJSXxrX7qleYOYQZWMnyIQ6R9sSrWWFADLqQ=;;"}'

```

An `alias` is optionally passed as argument, which is the unique identifier for
an enrollee entry. If not provided, one will be generated.

All provided URIs are stored in persistent memory in `/etc/multiap/dpp_uris.json`.
(If provided, the zero-touch device passphrase is also included in the same
file).

```
root@Aura-E750-943f0cd8c540:~# cat /etc/multiap/dpp_uris.json
{
  "enrollees":[
    {
      "alias":"cpe-1",
      "uri":"DPP:C:81\/1,115\/36;V:2;K:MDkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDIgADpRfiMElpJSXxrX7qleYOYQZWMnyIQ6R9sSrWWFADLqQ=;;"
    }
  ]
}
```

Once the map-controller has received the enrollee URI, it will listen and parse
its chirps and proceed to onboard the enrollee onto the network.

NOTE: Only legacy AKMs are supported. As backhaul configuration Request/Response/Result
are not yet implemented, fronthaul configurations relies on AP-Autoconfiguration,
which does not support passing DPP AKMs.

### Ethernet

The credentials that are provisioned are picked up based on the backhaul `ap`
sections in the map-controller configuration file.

Same as the Wi-Fi DPP onboarding, the enrollees bootstrap information must
provided to the map-controller via its UBUS API `dpp_enrollee_uri`:

```
ubus call map.controller dpp_enrollee_uri '{"uri":"DPP:C:81\/1,115\/36;V:2;K:MDkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDIgADpRfiMElpJSXxrX7qleYOYQZWMnyIQ6R9sSrWWFADLqQ=;;"}'
```

Once provided, map-controller will be able to perform DPP Ethernet onboarding,
triggered by AP-Autoconfig Search and DPP Direct Encapsulated messages.

## Control Depth of a Multi-AP Network

Limit the max number of Wi-Fi backhaul links that are allowed in "daisy-chained"
topology. By default the feature is disabled, which means that the EasyMesh
network is not limited to any number of Wi-Fi backhaul hops.

```
config controller 'controller'
	option enabled '1'
	...
	option max_node_bh_hops '2'        # number of allowed Wi-Fi hops
```

NOTE: Ethernet daisy-chains are still supported at any length, and forming a
daisy-chain with Eth to Wi-Fi is still possible.

## Objects and APIs

Map-controller offers a variety of UBUS APIs which can be categorized as:

**CMDU Request APIs** (send messages to agents):
* `query_*` commands - Send capability and metrics queries to agents
* `send_*` commands - Send specific requests like topology query, channel selection
* `trigger_*` commands - Trigger operations like ACS and channel clearing
* `steer*` commands - Client and backhaul steering operations
* `assoc_control` - Association control requests
* `cac_*` commands - CAC start/stop requests
* `dpp_*` commands - DPP enrollment operations
* `scan` - Scanning requests

**Data Retrieval APIs** (return stored/cached data):
* `status` and `status_full` - Network view and stored data
* `scanresults` - Previously collected scan data
* `dump_*` commands - Diagnostic and statistical information
* `timers` - Internal timer status

**Utility APIs**:
* `help` and `log` - Debugging and assistance commands
* `reconf` - Reload configuration and apply changes
* `reset_agent` and `disassociate_sta` - Administrative operations

The Multi-AP Controller object along with the supported APIs is given below -

````bash
'map.controller' @7a5eee22
        "help":{"command":"String"}
        "log":{"feature":"String","level":"Integer"}
        "status":{}
        "status_full":{}
        "reconf":{}
        "timers":{}
        "query_ap_caps":{"agent":"String"}
        "query_sta_caps":{"agent":"String","sta":"String","bssid":"String"}
        "query_bsta_caps":{"agent":"String"}
        "query_ap_metrics":{"agent":"String","bsslist":"Array","radiolist":"Array"}
        "query_sta_metrics":{"agent":"String","sta":"String"}
        "query_unassoc_sta_metrics":{"agent":"String","opclass":"Integer","channel":"Integer","stalist":"Array"}
        "query_channel_pref":{"agent":"String"}
        "query_beacon_metrics":{"agent":"String","sta":"String","opclass":"Integer","channel":"Integer","bssid":"String","reporting_detail":"Integer","ssid":"String","channel_report":"Array","request_element":"Array"}
        "send_channel_sel":{"agent":"String","radioid":"String","channel":"Integer","bandwidth":"Integer"}
        "trigger_channel_clearing":{"agent":"String"}
        "trigger_acs":{"agent":"String","band":"Integer","skip_dfs":"Integer","opclass":"Integer","bandwidth":"Integer","prevent_cac":"Integer"}
        "steer":{"agent":"String","sta":"String","src_bssid":"String","target_agent":"String","target_bssid":"String","abridged":"Integer","disassoc_tmo":"Integer","mbo_reason":"Integer"}
        "steer_op":{"agent":"String","sta":"String","src_bssid":"String","abridged":"Integer","window":"Integer","disassoc_tmo":"Integer","mbo_reason":"Integer"}
        "assoc_control":{"agent":"String","bssid":"String","mode":"Integer","validity_int":"Integer","stalist":"Array"}
        "steer_backhaul":{"agent":"String","target_agent":"String","target_band":"Integer","target_bssid":"String","bsta":"String","timeout":"Integer"}
        "scan":{"agent":"String","band":"Integer","radio":"String","opclass":"Array","channel":"Array","fresh_scan":"Boolean"}
        "scanresults":{"agent":"String","band":"Integer","radio":"String"}
        "cac_start":{"agent":"String","radio":"String","opclass":"Integer","channel":"Integer","method":"Integer","action":"Integer"}
        "cac_stop":{"agent":"String","radio":"String","opclass":"Integer","channel":"Integer"}
        "send_topology_query":{"agent":"String"}
        "send_hld":{"agent":"String","protocol":"Integer","data":"String"}
        "send_combined_metrics":{"agent":"String","bssid":"String"}
        "dump_unassoc_sta_metrics":{"sta":"String"}
        "dump_beacon_metrics":{"sta":"String"}
        "dump_policy":{"agent":"String"}
        "dump_steer_summary":{"sta":"String"}
        "dump_steer_history":{"sta":"String"}
        "dump_mlo_caps":{"agent":"String"}
        "dpp_enrollee_uri":{"uri":"String","type":"String"}
        "dpp_advertise_cce":{"agent":"String","enable":"Integer"}
        "disassociate_sta":{"agent":"String","sta":"String","reason":"Integer"}
        "reset_agent":{"agent":"String"}
        "dump_topology":{}
````

## UBUS events

Map-controller generates following events over UBUS -

Event | Event Data
------|-----------
map.controller | {"event":"agent_joined","data":{"agent":"aa:bb:cc:dd:ee:ff"}} |
map.controller | {"event":"autoconfigured","data":{"agent":"aa:bb:cc:dd:ee:ff","radio":"22:33:44:55:66:77", "band":2}} |
map.controller | {"event":"autoconfiguration_renew","data":{"agent":"aa:bb:cc:dd:ee:ff"}} |
map.controller | {"event":"agent_ageout","data":{"agent":"aa:bb:cc:dd:ee:ff"}} |
map.controller | {"event":"agent_onboarded","data":{"agent":"aa:bb:cc:dd:ee:ff","backhaulsta":"11:22:33:44:55:66","backhaulmac":"aa:bb:cc:11:22:xx","backhaulalid":"aa:bb:cc:11:22:33"}} |
map.controller | {"event":"backhaul_changed","data":{"agent":"aa:bb:cc:dd:ee:ff","backhaulsta":"11:22:33:44:55:66","backhaulmac":"aa:bb:cc:11:22:xx","backhaulalid":"aa:bb:cc:11:22:33"}} |
map.controller | {"event":"channel_changed","data":{"agent":"aa:bb:cc:dd:ee:ff","radio":"22:33:44:55:66:77","band":5,"channel":42,"opclass":128}} |
map.controller | {"event":"connected","data":{"sta":"11:22:33:44:55:66","agent":"aa:bb:cc:dd:ee:ff","bssid":"77:88:99:aa:bb:cc"}} |
map.controller | {"event":"disconnected","data":{"sta":"11:22:33:44:55:66","agent":"aa:bb:cc:dd:ee:ff","bssid":"77:88:99:aa:bb:cc"}} |
map.controller | {"event":"client_steer_request","data":{"bssid":"aa:bb:cc:dd:ee:ff","sta_mac":"11:22:33:44:55:66","target_bssid":"77:88:99:aa:bb:cc"}} |
map.controller | {"event":"client_steer_report","data":{"bssid":"aa:bb:cc:dd:ee:ff","sta_mac":"11:22:33:44:55:66","target_bssid":"77:88:99:aa:bb:cc","status":1}} |
map.controller | {"event":"client_steer_result","data":{"sta_mac":"aa:bb:cc:dd:ee:ff","status":1}} |
map.controller | {"event":"backhaul_steer_request","data":{"agent":"aa:bb:cc:dd:ee:ff","macaddr":"11:22:33:44:55:66","target_bssid":"77:88:99:aa:bb:cc","op_class":128,"channel":36}} |
map.controller | {"event":"backhaul_steer_result","data":{"agent":"aa:bb:cc:dd:ee:ff","macaddr":"11:22:33:44:55:66","target_bssid":"77:88:99:aa:bb:cc","result":0}} |
map.controller | {"event":"probe-req","data":{"macaddr":"aa:bb:cc:dd:ee:ff","almacaddr":"11:22:33:44:55:66","bssid":"77:88:99:aa:bb:cc","rcpi":42}} |
map.controller | {"event":"multiple_controllers","data":{"remote_almac":"aa:bb:cc:dd:ee:ff"}} |
map.controller | {"event":"higher_layer_data", "data":{"protocol":5,"data":"12ab34"}} |
map.controller | {"event":"tunneled_message", "data":{"protocol":10,"data":"12ab3456"}} |
||
---------------
