#ifndef DPP_H
#define DPP_H

#if (EASYMESH_VERSION >= 3)

#include <stdint.h>
#include <stddef.h>

struct uloop_fd;
struct controller;

#define FRAME_DST_ENROLLEE(type) \
		((type == DPP_PA_AUTHENTICATION_REQ) || \
		 (type == DPP_PA_AUTHENTICATION_CONF))

#define DPP_URI_FILE "/etc/multiap/dpp_uris.json"

#ifdef ZEROTOUCH_DPP
#define ZEROTOUCH_KEYFILE "/etc/multiap/.zt-keys.json"
#endif

#define ZT_PASSPHRASE_ADD_SUCCESS       0
#define ZT_PASSPHRASE_ADD_EXISTS        1
#define ZT_PASSPHRASE_ADD_ERROR        -1

enum dpp_event;

const char *dpp_frame_type2str(uint8_t type);

#ifdef ZEROTOUCH_DPP
int zerotouch_append_keyfile(struct controller *c, char *keystr);
#endif

int dpp_append_uri_file(struct controller *c, char *uri);
int dpp_cntlr_read_uris(struct controller *c);

void dpp_event_uloop_cb(struct uloop_fd *fd, unsigned int events);

int dpp_frame_handler(void *dpp, uint8_t *smac, enum dpp_event ev,
		      uint8_t *frame, size_t framelen);
#endif
#endif
