
#ifndef CNTLR_MAP_H
#define CNTLR_MAP_H

#include <stdint.h>
#include <stdbool.h>

struct blob_attr;
struct cmdu_buff;
struct controller;
struct node;
struct sta;
struct tlv;
struct ubus_request;


/**
 * @enum topology_notification_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum topology_notification_tlvs_order {
	TOPOLOGY_NOTIFICATION_MAC_ADDR_TYPE_IDX, // 0
	TOPOLOGY_NOTIFICATION_CLIENT_ASSOCIATION_EVENT_IDX,

	TOPOLOGY_NOTIFICATION_NUM_OF_TLV_TYPES
};

/**
 * @enum topology_response_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum topology_response_tlvs_order {
	TOPOLOGY_RESPONSE_DEVICE_INFORMATION_TYPE_IDX = 0,
	TOPOLOGY_RESPONSE_DEVICE_BRIDGING_CAPABILITIES_IDX,
	TOPOLOGY_RESPONSE_NON_1905_NEIGHBOR_DEVICE_LIST_IDX,
	TOPOLOGY_RESPONSE_NEIGHBOR_DEVICE_LIST_IDX,
	TOPOLOGY_RESPONSE_POWER_OFF_INTERFACE_IDX,
	TOPOLOGY_RESPONSE_L2_NEIGHBOR_DEVICE_IDX,
	TOPOLOGY_RESPONSE_SUPPORTED_SERVICE_IDX,
	TOPOLOGY_RESPONSE_AP_OPERATIONAL_BSS_IDX,
	TOPOLOGY_RESPONSE_ASSOCIATED_CLIENTS_IDX = 8,
#if (EASYMESH_VERSION >= 2)
	TOPOLOGY_RESPONSE_MULTIAP_PROFILE_IDX = 9,
#if (EASYMESH_VERSION >= 3)
	TOPOLOGY_RESPONSE_BSS_CONFIGURATION_REPORT_IDX = 10,
#if (EASYMESH_VERSION >= 6)
	TOPOLOGY_RESPONSE_BACKHAUL_STA_RADIO_CAPABILITY_IDX = 11,
	TOPOLOGY_RESPONSE_AP_MLD_CONFIG_IDX,
	TOPOLOGY_RESPONSE_BACKHAUL_STA_MLD_CONFIG_IDX,
	TOPOLOGY_RESPONSE_STA_MLD_CONFIG_IDX,
	TOPOLOGY_RESPONSE_TID_TO_LINK_MAPPING_POLICY_IDX,
#endif
#endif
#endif

	TOPOLOGY_RESPONSE_NUM_OF_TLV_TYPES
};

/**
 * @enum ap_autoconfiguration_search_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum ap_autoconfiguration_search_tlvs_order {

	AP_AUTOCONFIGURATION_SEARCH_AL_MAC_ADDRESS_TYPE_IDX = 0,
	AP_AUTOCONFIGURATION_SEARCH_SEARCHED_ROLE_IDX,
	AP_AUTOCONFIGURATION_SEARCH_AUTOCONFIG_FREQ_BAND_IDX,
	AP_AUTOCONFIGURATION_SEARCH_SUPPORTED_SERVICE_IDX,
	AP_AUTOCONFIGURATION_SEARCH_SEARCHED_SERVICE_IDX,
#if (EASYMESH_VERSION >= 2)
	AP_AUTOCONFIGURATION_SEARCH_MULTIAP_PROFILE_IDX = 5,
#if (EASYMESH_VERSION >= 3)
	AP_AUTOCONFIGURATION_SEARCH_DPP_CHIRP_VALUE_IDX	= 6,
#endif
#endif

	AP_AUTOCONFIGURATION_SEARCH_NUM_OF_TLV_TYPES
};

/**
 * @enum ap_autoconfiguration_response_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum ap_autoconfiguration_response_tlvs_order {
	AP_AUTOCONFIGURATION_RESP_SUPPORTED_ROLE_IDX = 0,
	AP_AUTOCONFIGURATION_RESP_SUPPORTED_FREQ_BAND,
	AP_AUTOCONFIGURATION_RESP_SUPPORTED_SERVICE_IDX,
#if (EASYMESH_VERSION >= 2)
	AP_AUTOCONFIGURATION_RESP_MULTIAP_PROFILE_IDX = 3,
#if (EASYMESH_VERSION >= 3)
	AP_AUTOCONFIGURATION_RESP_1905_SECURITY_CAPS_IDX = 4,
	AP_AUTOCONFIGURATION_RESP_DPP_CHIRP_VALUE_IDX,
#if (EASYMESH_VERSION >= 4)
	AP_AUTOCONFIGURATION_RESP_CONTROLLER_CAPS_IDX = 6,
#endif
#endif
#endif

	AP_AUTOCONFIGURATION_RESP_NUM_OF_TLV_TYPES
};

/**
 * @enum ap_autoconfiguration_wsc_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum ap_autoconfiguration_wsc_tlvs_order {
		AP_AUTOCONFIGURATION_WSC_AP_RADIO_BASIC_CAPS_IDX = 0,
		AP_AUTOCONFIGURATION_WSC_WSC_IDX,
#if (EASYMESH_VERSION >= 2)
		AP_AUTOCONFIGURATION_WSC_PROFILE2_AP_CAP_IDX,
		AP_AUTOCONFIGURATION_WSC_AP_RADIO_ADV_CAP_IDX,
#endif

		AP_AUTOCONFIGURATION_WSC_NUM_OF_TLV_TYPES
};

/**
 * @enum ack_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum ack_tlvs_order {
	ACK_ERROR_CODE_IDX = 0,

	ACK_NUM_OF_TLV_TYPES
};

/**
 * @enum ap_capability_report_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum ap_capability_report_tlvs_order {
	AP_CAPABILITY_REPORT_AP_CAPABILITY_IDX = 0,
	AP_CAPABILITY_REPORT_AP_RADIO_BASIC_CAPS_IDX,
	AP_CAPABILITY_REPORT_AP_HT_CAPS_IDX,
	AP_CAPABILITY_REPORT_AP_VHT_CAPS_IDX,
	AP_CAPABILITY_REPORT_AP_HE_CAPS_IDX,
#if (EASYMESH_VERSION >= 2)
	AP_CAPABILITY_REPORT_CHANNEL_SCAN_CAPABILITY_IDX = 5,
	AP_CAPABILITY_REPORT_CAC_CAPABILITY_IDX,
	AP_CAPABILITY_REPORT_PROFILE2_AP_CAPABILITY_IDX,
	AP_CAPABILITY_REPORT_METRIC_COLLECTION_INTERVAL_IDX,
#if (EASYMESH_VERSION >= 3)
	AP_CAPABILITY_REPORT_AP_WIFI6_CAPS_IDX = 9,
	AP_CAPABILITY_REPORT_1905_SECURITY_CAPS_IDX,
	AP_CAPABILITY_REPORT_DEVICE_INVENTORY_IDX,
#if (EASYMESH_VERSION >= 4)
	AP_CAPABILITY_REPORT_AP_RADIO_ADV_CAPABILITY_IDX = 12,
#if (EASYMESH_VERSION >= 6)
	AP_CAPABILITY_REPORT_AKM_SUITE_CAPS_IDX = 13,
	AP_CAPABILITY_REPORT_WIFI7_AGENT_CAPS_IDX,
	AP_CAPABILITY_REPORT_EHT_OPERATIONS_IDX,
#endif
#endif
#endif
#endif

	AP_CAPABILITY_REPORT_NUM_OF_TLV_TYPES
};

/**
 * @enum channel_preference_report_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum channel_preference_report_tlvs_order {
	CHANNEL_PREF_REPORT_CHANNEL_PREFERENCE_IDX = 0,
	CHANNEL_PREF_REPORT_RADIO_OPERATION_RESTRICTION_IDX,
#if (EASYMESH_VERSION >= 2)
	CHANNEL_PREF_REPORT_CAC_COMPLETION_REPORT_IDX = 2,
	CHANNEL_PREF_REPORT_CAC_STATUS_REPORT_IDX,
#if (EASYMESH_VERSION >= 6)
	CHANNEL_PREF_REPORT_EHT_OPERATIONS_IDX = 4,
#endif
#endif

	CHANNEL_PREF_REPORT_NUM_OF_TLV_TYPES
};

/**
 * @enum channel_selection_response_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum channel_selection_response_tlvs_order {
	CHANNEL_SELECTION_RESP_CHANNEL_SELECTION_IDX = 0,
#if (EASYMESH_VERSION >= 4)
	CHANNEL_SELECTION_RESP_SPATIAL_REUSE_CONFIG_IDX = 1,
#if (EASYMESH_VERSION >= 6)
	CHANNEL_SELECTION_RESP_EHT_OPERATIONS_IDX = 2,
#endif
#endif

	CHANNEL_SELECTION_RESP_NUM_OF_TLV_TYPES
};

/**
 * @enum operating_channel_report_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum operating_channel_report_tlvs_order {
	OPER_CHANNEL_REPORT_OPERATING_CHANNEL_IDX = 0,
#if (EASYMESH_VERSION >= 4)
	OPER_CHANNEL_REPORT_SPATIAL_REUSE_IDX =	1,
#if (EASYMESH_VERSION >= 6)
	OPER_CHANNEL_REPORT_EHT_OPERATIONS_IDX = 2,
#endif
#endif

	OPER_CHANNEL_REPORT_NUM_OF_TLV_TYPES
};

/**
 * @enum ap_metrics_response_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum ap_metrics_response_tlvs_order {
	AP_METRICS_RESP_AP_METRICS_IDX = 0,
	AP_METRICS_RESP_ASSOCIATED_STA_TRAFFIC_STATS_IDX,
	AP_METRICS_RESP_ASSOCIATED_STA_LINK_METRICS_IDX,
#if (EASYMESH_VERSION >= 2)
	AP_METRICS_RESP_AP_EXTENDED_METRICS_IDX = 3,
	AP_METRICS_RESP_RADIO_METRICS_IDX,
	AP_METRICS_RESP_ASSOCIATED_STA_EXT_LINK_METRICS_IDX,
#if (EASYMESH_VERSION >= 3)
	AP_METRICS_RESP_ASSOCIATED_WIFI6_STA_STATUS_IDX = 6,
#if (EASYMESH_VERSION >= 6)
	AP_METRICS_RESP_AFFILIATED_AP_METRICS_IDX = 7,
	AP_METRICS_RESP_AFFILIATED_STA_METRICS_IDX,
#endif
#endif
#endif

	AP_METRICS_RESP_NUM_OF_TLV_TYPES
};

/**
 * @enum client_capability_report_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum client_capability_report_tlvs_order {
	CLIENT_CAPABILITY_REPORT_CLIENT_INFO_IDX = 0,
	CLIENT_CAPABILITY_REPORT_CLIENT_CAPABILITY_IDX,
	CLIENT_CAPABILITY_REPORT_ERROR_CODE_IDX,

	CLIENT_CAPABILITY_REPORT_NUM_OF_TLV_TYPES
};

/**
 * @enum link_metric_response_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum link_metric_response_tlvs_order {
	LINK_METRICS_RESP_TRANSMITTER_LINK_METRICS_IDX = 0,
	LINK_METRICS_RESP_RECEIVER_LINK_METRICS_IDX,

	LINK_METRICS_RESP_NUM_OF_TLV_TYPES
};

/**
 * @enum assoc_sta_link_metrics_response_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum assoc_sta_link_metrics_response_tlvs_order {
	ASSOC_STA_LINK_METRICS_RESP_ASSOCIATED_STA_LINK_METRICS_IDX = 0,
	ASSOC_STA_LINK_METRICS_RESP_ERROR_CODE_IDX,
#if (EASYMESH_VERSION >= 2)
	ASSOC_STA_LINK_METRICS_RESP_ASSOCIATED_STA_EXT_LINK_METRICS_IDX = 2,
#endif

	ASSOC_STA_LINK_METRICS_RESP_NUM_OF_TLV_TYPES
};

/**
 * @enum unassoc_sta_link_metrics_response_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum unassoc_sta_link_metrics_response_tlvs_order {
	UNASTA_LINK_METRICS_RESP_UNASSOCIATED_STA_LINK_METRICS_IDX = 0,
#if (EASYMESH_VERSION >= 6)
	UNASTA_LINK_METRICS_RESP_STA_MLD_CONFIG_IDX,
#endif

	UNASTA_LINK_METRICS_RESP_NUM_OF_TLV_TYPES
};

/**
 * @enum beacon_metrics_response_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum beacon_metrics_response_tlvs_order {
	BEACON_METRICS_RESP_BEACON_METRICS_IDX = 0,

	BEACON_METRICS_RESP_NUM_OF_TLV_TYPES
};

/**
 * @enum steering_btm_report_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum steering_btm_report_tlvs_order {
	STEERING_BTM_REPORT_BTM_REPORT_IDX = 0,

	STEERING_BTM_REPORT_NUM_OF_TLV_TYPES
};

/**
 * @enum backhaul_sta_steer_response_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum backhaul_sta_steer_response_tlvs_order {
	BH_STA_STEER_RESP_BACKHAUL_STEERING_RESPONSE_IDX = 0,
	BH_STA_STEER_RESP_ERROR_CODE_IDX,

	BH_STA_STEER_RESP_NUM_OF_TLV_TYPES
};

/**
 * @enum channel_scan_report_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum channel_scan_report_tlvs_order {
	CHAN_SCAN_REPORT_TIMESTAMP_IDX = 0,
	CHAN_SCAN_REPORT_CHANNEL_SCAN_RES_IDX,
#if (EASYMESH_VERSION >= 6)
	CHAN_SCAN_REPORT_MLD_STRUCTURE_IDX = 2,
#endif

	CHAN_SCAN_REPORT_NUM_OF_TLV_TYPES
};

/**
 * @enum client_disassociation_stats_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum client_disassociation_stats_tlvs_order {
	STA_DISASSOC_STATS_STA_MAC_ADDR_IDX = 0,
	STA_DISASSOC_STATS_REASON_CODE_IDX,
	STA_DISASSOC_STATS_ASSOCIATED_STA_TRAFFIC_STATS_IDX,
#if (EASYMESH_VERSION >= 6)
	STA_DISASSOC_STATS_AFFILIATED_STA_METRICS_IDX = 3,
#endif

	STA_DISASSOC_STATS_NUM_OF_TLV_TYPES
};

/**
 * @enum association_status_notification_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum association_status_notification_tlvs_order {
	ASSOC_STATUS_NOTIF_ASSOCIATION_STATUS_IDX = 0,

	ASSOC_STATUS_NOTIF_NUM_OF_TLV_TYPES
};

/**
 * @enum tunneled_message_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum tunneled_message_tlvs_order {
	TUNNELED_MESSAGE_SOURCE_INFO_IDX = 0,
	TUNNELED_MESSAGE_TUNNELED_MSG_TYPE_IDX,
	TUNNELED_MESSAGE_TUNNELED_MSG_IDX,

	TUNNELED_MESSAGE_NUM_OF_TLV_TYPES
};

/**
 * @enum backhaul_sta_capability_report_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum backhaul_sta_capability_report_tlvs_order {
	BH_STA_CAPS_REPORT_BACKHAUL_STA_RADIO_CAPABILITY_IDX = 0,
#if (EASYMESH_VERSION >= 6)
	BH_STA_CAPS_REPORT_CLIENT_INFO_IDX = 1,
#endif

	BH_STA_CAPS_REPORT_NUM_OF_TLV_TYPES
};

#if (EASYMESH_VERSION >= 3)
/**
 * @enum proxied_encap_dpp_tlvs_order
 * @brief specifies order of output TLVs and max. number of different TLVs
 */
enum proxied_encap_dpp_tlvs_order {
	PROXIED_ENCAP_1905_ENCAP_DPP_IDX = 0,
	PROXIED_ENCAP_CHIRP_VALUE_IDX,

	PROXIED_ENCAP_DPP_MAX_NUMBER_OF_TLV_TYPES
};

/**
 * @enum direct_encap_dpp_tlvs_order
 * @brief specifies order of output TLVs and max. number of different TLVs
 */
enum direct_encap_dpp_tlvs_order {
	DIRECT_ENCAP_DPP_MESSAGE_IDX = 0,

	DIRECT_ENCAP_DPP_MAX_NUMBER_OF_TLV_TYPES
};

/**
 * @enum bss_configuration_request_tlvs_order
 * @brief specifies order of output TLVs and max. number of different TLVs
 */
enum bss_configuration_request_tlvs_order {
	BSS_CFG_REQ_MULTIAP_PROFILE_IDX = 0,
	BSS_CFG_REQ_SUPPORTED_SERVICE_IDX,
	BSS_CFG_REQ_AKM_SUITE_CAPS_IDX,
	BSS_CFG_REQ_AP_RADIO_BASIC_CAPS_IDX,
	BSS_CFG_REQ_BACKHAUL_STA_RADIO_CAPS_IDX,
	BSS_CFG_REQ_PROFILE2_AP_CAP_IDX,
	BSS_CFG_REQ_AP_RADIO_ADVANCED_CAPS_IDX,
	BSS_CFG_REQ_CONFIG_REQUEST_IDX,
#if (EASYMESH_VERSION >= 6)
	BSS_CFG_REQ_AP_CAPS_IDX = 8,
	BSS_CFG_REQ_AP_HT_CAPS_IDX,
	BSS_CFG_REQ_AP_VHT_CAPS_IDX,
	BSS_CFG_REQ_AP_HE_CAPS_IDX,
	BSS_CFG_REQ_AP_WIFI6_CAPSS_IDX,
	BSS_CFG_REQ_WIFI7_AGENT_CAPS_IDX,
	BSS_CFG_REQ_EHT_OPERATIONS,
#endif

	BSS_CFG_REQ_MAX_NUMBER_OF_TLV_TYPES
};

/**
 * @enum bss_configuration_result_tlvs_order
 * @brief specifies order of output TLVs and max. number of different TLVs
 */
enum bss_configuration_result_tlvs_order {
	BSS_CFG_RESULT_BSS_CONFIG_REPORT_IDX = 0,
	BSS_CFG_RESULT_DEFAULT_8021Q_SETTINGS_IDX,
	BSS_CFG_RESULT_TRAFFIC_SEPARATION_POLICY_IDX,
#if (EASYMESH_VERSION >= 6)
	BSS_CFG_RESULT_AP_MLD_CONFIG_IDX = 3,
	BSS_CFG_RESULT_BACKHAUL_STA_MLD_CONFIG_IDX,
	BSS_CFG_RESULT_EHT_OPERATIONS_IDX,
#endif

	BSS_CFG_RESULT_MAX_NUMBER_OF_TLV_TYPES
};

/**
 * @enum dpp_bootstraping_uri_notification_tlvs_order
 * @brief specifies order of output TLVs and max. number of different TLVs
 */
enum dpp_bootstraping_uri_notification_tlvs_order {
	DPP_BOOTSTRAP_URI_NOTIF_IDX = 0,

	DPP_BOOTSTRAP_URI_NOTIF_MAX_NUMBER_OF_TLV_TYPES
};

/**
 * @enum chirp_notification_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum chirp_notification_tlvs_order {
	DPP_CHIPR_NOTIFICATION_DPP_CHIRP_VALUE_IDX = 0,

	DPP_CHIPR_NOTIFICATION_NUM_OF_TLV_TYPES
};
#endif

#if (EASYMESH_VERSION >= 6)
/**
 * @enum early_ap_capability_report_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum early_ap_capability_report_tlvs_order {
	EARLY_AP_CAP_REPORT_AP_CAPABILITY_IDX = 0,
	EARLY_AP_CAP_REPORT_AP_RADIO_BASIC_CAPABILITIES_IDX,
	EARLY_AP_CAP_REPORT_AKM_SUITE_CAPS_IDX,
	EARLY_AP_CAP_REPORT_AP_HT_CAPABILITIES_IDX,
	EARLY_AP_CAP_REPORT_AP_VHT_CAPABILITIES_IDX,
	EARLY_AP_CAP_REPORT_AP_HE_CAPABILITIES_IDX,
	EARLY_AP_CAP_REPORT_AP_WIFI6_CAPS_IDX,
	EARLY_AP_CAP_REPORT_WIFI7_AGENT_CAPS_IDX,
	EARLY_AP_CAP_REPORT_EHT_OPERATIONS_IDX,
	EARLY_AP_CAP_REPORT_1905_SECURITY_CAPS_IDX,
	EARLY_AP_CAP_REPORT_CAC_CAPABILITY_IDX,
	EARLY_AP_CAP_REPORT_PROFILE2_AP_CAPABILITY_IDX,
	EARLY_AP_CAP_REPORT_METRIC_COLLECTION_INTERVAL_IDX,
	EARLY_AP_CAP_REPORT_DEVICE_INVENTORY_IDX,
	EARLY_AP_CAP_REPORT_AP_RADIO_ADV_CAPABILITY_IDX,

	EARLY_AP_CAP_REPORT_NUM_OF_TLV_TYPES
};
#endif

int send_dpp_cce_indication(struct controller *c, uint8_t *agent,
			     bool advertise);
int send_dpp_cce_indication_all(struct controller *c, bool advertise);
int cntlr_request_bcn_metrics_sta(struct controller *c, struct sta *s, bool match_band);

extern bool is_cmdu_for_us(void *module, uint16_t type);

extern int cntlr_handle_map_event(void *module, uint16_t cmdutype, uint16_t mid,
				  char *rxif, uint8_t *src, uint8_t *origin, uint8_t *tlvs,
				  int len);

void send_cmdu_cb(struct ubus_request *req, int type, struct blob_attr *msg);
int send_cmdu_ubus(struct controller *a, struct cmdu_buff *cmdu);
uint16_t send_cmdu(struct controller *a, struct cmdu_buff *cmdu);


extern int handle_link_metrics_response(struct controller *c, struct cmdu_buff *cmdu, struct node *n);

int cntlr_set_link_profile(struct controller *c, struct node *n, struct cmdu_buff *cmdu);

int get_tv_scan_from_cmdu(struct cmdu_buff *cmdu, struct tlv *tv_scan[], int *num_res);

//struct cntlr_ackq_cookie *cntlr_alloc_ackq_cookie(struct cmdu_buff *cmdu);
//void cntlr_free_ackq_cookie(struct agent_ackq_cookie *c);

#endif /* CNTLR_MAP_H */
