#ifndef CONFIG_HELPERS_H
#define CONFIG_HELPERS_H

#define list_copy(a, b, type)                                           \
	({                                                              \
		typeof(type *) ____ptr, ____tmp;                        \
		list_for_each_entry_safe(____ptr, ____tmp, a, list) {   \
			list_del(&____ptr->list);                       \
			list_add_tail(&____ptr->list, b);               \
		}                                                       \
	})



#define list_memcmp(a, b, type, offset)                                      \
	({                                                                   \
		int z = 0;                                                   \
		typeof(type *) ____ptr = NULL, ____p;                        \
		____p = list_first_entry(a, type, list);                     \
		list_for_each_entry(____ptr, b, list) {                      \
			if (!____p || memcmp(____p, ____ptr, offset)) {	     \
				z = 1;                                       \
				break;                                       \
			}                                                    \
			____p = list_entry(____p->list.next, type, list);    \
		}                                                            \
		z;                                                           \
	})



#define list_policy_memcmp(c, d, t, o)                                       \
	({                                                                   \
		int z = 0;                                                   \
		typeof(t *) ____d, ____c;                                    \
		____c = list_first_entry(c, t, list);                        \
		list_for_each_entry(____d, d, list) {                        \
			if (memcmp(____c, ____d, sizeof(t) - o)) {           \
				z = 1;                                       \
				____d->is_policy_diff = 1;                   \
			} else {                                             \
				if (list_memcmp(&____d->radiolist,           \
				    &____c->radiolist, struct radio_policy,  \
				    offsetof(struct radio_policy, list)))  { \
					z = 1;                               \
					____d->is_policy_diff = 1;           \
				}                                            \
			}                                                    \
			____c = list_entry(____c->list.next, t, list);       \
		}                                                            \
		z;                                                           \
	})

#define list_for_multiple_entry(pos, pos1, head, head1, field, field1)					\
	for (pos = list_first_entry(head, __typeof__(*pos), field),					\
			pos1 = list_first_entry(head1, __typeof__(*pos1), field1);			\
			(&pos->field != (head)) && (&pos1->field1 != (head1));				\
			pos = list_entry(pos->field.next, __typeof__(*pos), field),			\
			pos1 = list_entry(pos1->field1.next, __typeof__(*pos1), field1))

#endif
