/*
 * cntlr_events.h - Controller generated events for reporting.
 *
 * Copyright (C) 2025 Genexis Sweden AB. All rights reserved.
 *
 * See LICENSE file for source code license information.
 *
 */

#ifndef CNTLR_EVENTS_H
#define CNTLR_EVENTS_H

/* Controller generate events of the following format -
 *
 * { map.controller '{"event": "String" [,"data": {<event-data>}]} }'
 *
 * where "event" is a string type from one of the following CNTLR_EVENT_* defines,
 * and "data" is optionally present depending on the "event".
 *
 */

#define CNTLR_EVENT_MULTIPLE_CNTLR        "multiple_controller"
#define CNTLR_EVENT_AGENT_ONBOARDED       "agent_onboarded"
#define CNTLR_EVENT_CLIENT_STEER_REQUEST  "client_steer_request"
#define CNTLR_EVENT_CLIENT_STEER_REPORT   "client_steer_report"
#define CNTLR_EVENT_CLIENT_STEER_RESULT   "client_steer_result"
#define CNTLR_EVENT_BSTA_STEER_REQUEST    "backhaul_steer_request"
#define CNTLR_EVENT_BSTA_STEER_RESULT     "backhaul_steer_result"
#define CNTLR_EVENT_HLD                   "higher_layer_data"

#ifdef PROPAGATE_PROBE_REQ
#define CNTLR_EVENT_PROBE_REQ             "probe-req"
#endif


#endif /* CNTLR_EVENTS_H */
