#ifndef SCAN_H
#define SCAN_H

#include <stdint.h>

struct controller;
struct node;
struct netif_radio;
struct tlv;
struct tlv_channel_scan_result;
struct wifi_radio_scan_capabilities;
struct wifi_scanres_element;


#define SCANRES_MAX_NUM 4 /* maximum number of stored results per radio */

#define SCANRES_MAX_AGE 1800 /* secs */


void cntlr_scan_caps_opclass_dump(struct wifi_radio_scan_capabilities *scan_caps);

int cntlr_parse_radio_scan_caps(struct controller *c, struct node *n,
		struct tlv *t);
struct wifi_scanres_element *find_scanres_el(struct controller *c,
		uint8_t *radio, char *timestamp);
struct wifi_scanres_element *get_scanlist_element(struct controller *c,
		uint8_t *radio, char *timestamp);
int add_scanres_element(struct controller *c, struct tlv_channel_scan_result *tlv, char *timestamp);
void cntlr_radio_remove_old_scanres(struct controller *c);
int cntlr_radio_update_scanlist(void *cntlr, char *timestamp,
		struct tlv **tv_scan, int num_result);
int cntlr_radio_clean_scanlist_el(struct wifi_scanres_element *el);
void cntlr_request_scan_cache(struct controller *c, struct node *n, const struct netif_radio *r);

#endif
