/*
 * timeutils.h
 * Header file for time utility functions.
 *
 * Copyright (C) 2025 IOPSYS Software Solutions AB. All rights reserved.
 *
 * See LICENSE file for license related information.
 *
 */

#ifndef TIMEUTILS_H
#define TIMEUTILS_H

#include <stdbool.h>
#include <stdint.h>
#include <time.h>

struct timespec;

time_t timestamp_to_time(const char *tsp);

int timestamp_invalid(struct timespec *ts);
bool timestamp_less_than(const struct timespec *lhs, const struct timespec *rhs);
bool timestamp_greater_than(const struct timespec *lhs, const struct timespec *rhs);

#endif /* TIMEUTILS_H */
