#ifndef CONTROLLER_COMMAND_IMPL_H
#define CONTROLLER_COMMAND_IMPL_H

#include <stddef.h>
#include <stdint.h>
#include <libubox/blobmsg.h>

struct controller_command_attr {
	struct blobmsg_policy pol;
	uint8_t optional;
	const char *help;
};

typedef int (*command_handler_t)(void *controller, void *args, void *out);

struct controller_command {
	const char *command;
	command_handler_t handler;
	const char *help;
	size_t num_attrs;
	struct controller_command_attr *attrs;
};

#ifndef DECLARE_COMMAND
#define DECLARE_COMMAND(f)	extern int controller_handle_ ## f(void *controller, void *args, void *out);
#define COMMAND(f)		controller_handle_ ## f
#endif

DECLARE_COMMAND(help);
DECLARE_COMMAND(log);
DECLARE_COMMAND(query_ap_caps);
DECLARE_COMMAND(query_sta_caps);
DECLARE_COMMAND(query_bsta_caps);
DECLARE_COMMAND(query_ap_metrics);
DECLARE_COMMAND(query_sta_metrics);
DECLARE_COMMAND(query_unassoc_sta_metrics);
DECLARE_COMMAND(query_channel_pref);
DECLARE_COMMAND(query_beacon_metrics);
DECLARE_COMMAND(send_channel_sel);
DECLARE_COMMAND(trigger_channel_clearing);
DECLARE_COMMAND(trigger_acs);
DECLARE_COMMAND(steer);
DECLARE_COMMAND(steer_op);
DECLARE_COMMAND(assoc_control);
DECLARE_COMMAND(steer_backhaul);
//DECLARE_COMMAND(set_policy);
DECLARE_COMMAND(scan);
DECLARE_COMMAND(scanresults);
DECLARE_COMMAND(cac_start);
DECLARE_COMMAND(cac_stop);
DECLARE_COMMAND(send_hld);
DECLARE_COMMAND(send_combined_metrics);
DECLARE_COMMAND(send_topology_query);
DECLARE_COMMAND(dump_steer_summary);
DECLARE_COMMAND(dump_steer_history);
DECLARE_COMMAND(dump_unassoc_sta_metrics);
DECLARE_COMMAND(dump_beacon_metrics);
DECLARE_COMMAND(dump_policy);
#if (EASYMESH_VERSION >= 6)
DECLARE_COMMAND(dump_mlo_caps);
#endif
DECLARE_COMMAND(status);
DECLARE_COMMAND(status_full);
DECLARE_COMMAND(timers);
#if (EASYMESH_VERSION > 2)
#ifdef USE_LIBDPP
DECLARE_COMMAND(dpp_enrollee_uri);
DECLARE_COMMAND(dpp_advertise_cce);
#ifdef ZEROTOUCH_DPP
DECLARE_COMMAND(zerotouch_set_key);
#endif
#endif
#endif
#ifdef EASYMESH_VENDOR_EXT
DECLARE_COMMAND(disassociate_sta);
DECLARE_COMMAND(reset_agent);
#endif
DECLARE_COMMAND(dump_topology);
#endif /* CONTROLLER_COMMAND_IMPL_H */
