
# STA steering

The Multi-AP Controller supports STA steering as described in the EasyMesh standard.

It allows loadable 'steer' plugins that can evaluate a STA's steering criteria.
These plugins come with their own private configuration, which the Controller does not need to know about.

The Controller only pass certain EasyMesh messages to the 'steer' plugins, which they request the Controller to provide.

After the 'steer' plugin decides that a STA should be steered, Controller sends a Client Steer Request EasyMesh message to steer the STA.


# Prerequisite

Although Controller initiates the Client Steer Request message, it cannot know when to issue the request.
For that, the 'steer' plugins evaluate the steering criteria and notify the Controller of the steer verdict.

Examples of STA steer criteria can be -

1) Low signal
2) Low rate
3) High channel congestion
4) High error counters


# Steer plugins

On startup, Controller loads the 'steer' plugins from the path `/usr/lib/mapcontroller`.

See `src/README-STA-Steering.md` for more details about the steer plugins.


## Configuration

**/etc/config/mapcontroller**

The config section config `sta_steering` is applicable for all STAs and all Agents in
the Multi-AP network.

Set `enable_sta_steer` to '1' to enable STA steering.
Setting the option to '0' disables Controller initiated STA steering.

````
config sta_steering
        option enable_sta_steer '1'

````

The following config options in the `sta_steering` section set the various steering related threshold values applicable to all STAs in the network.

````
config sta_steering
        option report_rcpi_threshold_2g '80'
        option report_rcpi_threshold_5g '96'
        option report_rcpi_threshold_6g '96'
        option rcpi_threshold_2g '70'
        option rcpi_threshold_5g '86'
        option rcpi_threshold_6g '86'
        option plugins_enabled '1'
        option plugins_policy 'any'
        list plugins 'rcpi'
        list plugins 'rate'
````

User can override the steering config on a per-Agent or per-Radio basis.

STA steering config options applicable at per-Radio level -
````
config radio 'radio_44d4376af4cf'
        option agent_id '46:d4:37:6a:f4:c0'
        option macaddr '44:d4:37:6a:f4:cf'
        option band '5'
        option rcpi_threshold '86'
        option report_rcpi_threshold '96'
````

STA steering config options applicable at per-Agent basis -
````
config node 'node_46d4376af4c0'
        option agent_id '46:d4:37:6a:f4:c0'
        list steer_exclude 'e0:d4:e8:79:c4:ee'
        list steer_exclude 'e0:d4:e8:79:c4:11'
        list steer_exclude_btm 'aa:bb:cc:dd:ee:ff'
````

## How it works

* Controller sets the associated STAs' metrics reporting policy.
* A Multi-AP Agent sends STA Link Metrics Response messages to the Controller either a) periodically or b) whenever a STA's uplink RCPI goes below a certain threshold value (config: *report_rcpi_threshold_\**).
* Controller notifies STAs' Link Metrics Response to the loaded steer plugins.
* The steer plugins may ask the Controller to trigger Beacon Metrics Request EasyMesh messages for the STA.
* Controller notifies the Beacon Metrics Response(s) for the STA to the steer plugins, if any received in response to it's above request(s).
* The steer plugins may ask the Controller to fetch Unassociated STA Link Metrics for the STA from the neighboring Agents.
* Again, Controller notifies the steer plugins of the Unassociated STA link metrics response(s) for the STA, if any received from the neighbor Agents.
* The steer plugins decide if the STA should be steered or not, based on the network condition and available STA metrics at that point.
* If the steer verdict is OK, then Controller issues a Client Steering Request EasyMesh message for the STA.
* As part of the steer verdict, the steer plugins also provide the target-AP to which the STA should be steered to.
* Upon receiving the Client Steering Request, the Multi-AP Agent is expected to send a 11v BTM Request to the STA.
* Upon receiving a 11v BTM Response from the STA, the Multi-AP Agent replies back to the Controller with a Client Steering BTM Report EasyMesh message containing the BTM steering status code.
* Controller updates the STA's state and steer metrics accordingly.


## Steer sxclusion lists
STA(s) can be excluded from Controller initiated steering by using either or both
the following config options -

**/etc/config/mapcontroller**

``` shell
config node 'node_46d4376af4c0'       
        option agent_id '46:d4:37:6a:f4:c0'      
        list steer_exclude 'e0:d4:e8:79:c4:ee'        # exclude this STA from steering
        list steer_exclude_btm 'e0:d4:e8:79:c4:11'    # exclude this STA from 802.11v BTM based steering
```

NOTE: The above options are applicable on a per-Agent basis.

## BandSteer

**(/etc/config/mapcontroller)**

``` shell
config sta_steering
	option bandsteer ‘1’
```

Controller pass this config option to let the steer plugins know if STA bandsteering is allowed or not while deciding for the suitable target-APs.

## Command 'steer'
Controller also provides a 'steer' command, which can be used to trigger STA steering explicitly.
This command bypass the STA steer plugins allowing the Controller to send a Client Steer Request EasyMesh message directly to an Agent.

``` shell
ubus call map.controller steer '{"agent":"46:d4:37:fe:2d:d0","sta":"c4:03:a8:86:97:0a","src_bssid":"44:d4:37:fe:2d:df","target_agent":"5a:00:32:e6:c8:c0","target_bssid":"3e:00:32:e6:c8:c8","abridged":"0","disassoc_tmo":10,"mbo_reason":"0"}'
```
See `map.controller` 'help' command to know about the different arguments that the 'steer' command can take.


## Developer notes

*TODO*
