# Map-controller APIs

Overview of the exposed UBUS API as well as the TR-181 DataModel Operate
commands, which interact with map-controller.

## UBUS API

APIs exposed over the microbus are used primarily to issue CMDU requests for
network statistics or triggering operations, such as steering or scanning.
However, APIs are additionally available to expose data to the TR-181 DataModel
and debugging, such as steering statistics and network topology information.

### API Dump
```
root@nvg578m-a0e7ae917984:~# ubus -v list map.controller
'map.controller' @71542861
	"status":{}
	"status_full":{}
	"timers":{}
	"dpp_enrollee_uri":{"uri":"String","type":"String"}
	"steer_summary":{"sta":"String"}
	"steer_history":{"sta":"String"}
	"ap_caps":{"agent":"String"}
	"sta_caps":{"agent":"String","sta":"String","bssid":"String"}
	"channel_pref":{"agent":"String"}
	"channel_recalc":{"agent":"String","skip_dfs":"Boolean"}
	"channel_cleanup":{"agent":"String"}
	"bk_steer":{"agent":"String","bssid":"String","channel":"Integer","op_class":"Integer","bksta":"String"}
	"agent_policy":{"agent":"String","radiolist":"Array","bsslist":"Array"}
	"channel_select":{"agent":"String","radio_id":"String","class_id":"Integer","channel":"Array","preference":"Integer","transmit_power":"Integer"}
	"reconfig_ap":{"agent":"String"}
	"steer":{"agent":"String","src_bssid":"String","sta":"Array","target_bssid":"Array","steer_timeout":"Integer","btm_timeout":"Integer","steer_req_mode":"Boolean"}
	"client_assoc_cntlr":{"agent":"String","bssid":"String","assoc_cntl_mode":"Integer","assoc_valid_timeout":"Integer","stalist":"Array"}
	"ap_metric_query":{"agent":"String","bsslist":"Array","radiolist":"Array"}
	"scan":{"agent":"String","radio":"Array","opclass":"Array","channel":"Array","fresh_scan":"Boolean"}
	"scan_results":{"radio":"Array"}
	"sta_metric_query":{"agent":"String","sta":"String"}
	"unassoc_sta_lm_query":{"agent":"String","opclass":"Integer","metrics":"Array"}
	"unassoc_sta_lm_resp":{"sta":"String"}
	"bcn_metrics_query":{"agent":"String","sta":"String","opclass":"Integer","channel":"Integer","bssid":"String","reporting_detail":"Integer","ssid":"String","channel_report":"Array","request_element":"Array"}
	"bcn_metrics_resp":{"sta":"String"}
	"bk_caps":{"agent":"String"}
	"topology_query":{"agent":"String"}
	"cac_req":{"agent":"String","radiolist":"Array"}
	"cac_term":{"agent":"String","radiolist":"Array"}
	"higher_layer_data":{"agent":"String","protocol":"Integer","data":"String"}
	"send_combined_metrics":{"agent":"String","bssid":"String"}
	"sync":{"agent":"String"}
	"dpp_cce_indication":{"agent":"String","cce_advertise":"Boolean"}
```

### API Table

| Method  		   | CMDU					 | Description 													|
|--------------------------|---------------------------------------------|--------------------------------------------------------------------------------------------------------------|
|status			   | Information gathered from a number of CMDUs | Show various statistics for each node, their radios, clients etc.  						|
|status_full		   | Same as status				 | Same as status, however includes additional supported opclass information 					|
|timers			   | N/A					 | Show internal timers, primarily used for debugging 								|
|dpp_enrollee_uri	   | N/A					 | Provide DPP Enrollee QR Code 										|
|steer_summary		   | Client Steering BTM Report			 | Summary of steer statistics, i.e. attempts triggered, successfully completed and failed			|
|steer_history		   | Client Steering BTM Report			 | Per station steer attempt history  										|
|ap_caps		   | AP Capability Query			 | Trigger AP capability gathering, i.e. HT/VHT/HE caps 							|
|sta_caps		   | Client Capability Query			 | Trigger client capability gathering, i.e. client connectivity information and (re)assoc frame 		|
|channel_pref		   | Channel Preference Query			 | Trigger query for an agents channel preferences, restrictions and CAC status 				|
|channel_recalc		   | Channel Selection Request			 | Calculate and request best channel for each radio in the network   						|
|channel_cleanup	   | CAC Request				 | Request agent to perform CAC at a radio of map-controller choosing 						|
|bk_steer		   | Backhaul Steer Request			 | Steer a backhaul STA to a different backhaul BSSID 								|
|agent_policy		   | Policy Config Request			 | **Deprecated trigger** Provision controller mandated policies  						|
|channel_select		   | Channel Selection Request			 | Provision tx power and channel preferences accompanied by reason to an agent 				|
|reconfig_ap		   | AP-Autoconfiguration Renew 		 | **Deprecated trigger** Provision newest network configuration (i.e. SSID, key, encryption) to all agents  	|
|steer			   | Client Steering Request			 | Request to steer client to a different BSSID 								|
|client_assoc_cntlr	   | Client Association Control Request		 | Perform client association control at a per BSSID-to-STA(s) level 						|
|ap_metric_query	   | AP Metrics Query				 | Trigger AP statistic and associated STA statistic gathering   						|
|scan			   | Channel Scan Request			 | Trigger fresh scan or request cached data for a set of radio(s)/opclass/channel(s) of an agent 		|
|scan_results		   | Channel Scan Report			 | Show scan results gathered passively via Channel Scan Report  						|
|sta_metric_query	   | Associated STA Link Metrics Query		 | Request for link metrics of an associated client, i.e. throughput and RCPI   				|
|unassoc_sta_lm_query	   | Unassociated STA Link Metric Query		 | Trigger monitoring of an unassociated client			  						|
|unassoc_sta_lm_resp	   | Unassociated STA Link Metric Response	 | Show link metrics of an unassociated client, as gathered passively via unassoc STA link metric responses  	|
|bcn_metrics_query	   | Beacon Metrics Query			 | Request beacon metrics from a client										|
|bcn_metrics_resp	   | Beacon Metrics Response 			 | Show information passively gathered from beacon metrics responses 						|
|bk_caps		   | Backhaul STA Capability Query		 | Request backhaul STA capabilities 										|
|topology_query		   | Topology Query				 | Request for network topology information									|
|cac_req		   | CAC Request				 | Perform CAC on radio(s)/opclass/channel(s) using a provided CAC method and completion action			|
|cac_term		   | CAC Termination				 | Terminate CAC on radio(s)/opclass/channel(s) 								|
|higher_layer_data	   | Higher Layer Data				 | Send opaque payload over 1905 abstraction layer								|
|send_combined_metrics	   | Combined Infrastructure Metrics		 | Inform agents of rx and tx link metrics over a backhaul link 						|
|sync			   | Higher Layer Data				 | Sync map-controller configuration to all nodes with a dormant map-controller *IOPSYS Add-on* 		|
|dpp_cce_indication	   | DPP CCE Indication				 | Inform agent to enable/disable CCE advertisement in beacons and probe responses				|


## TR-181 DataModel API

TR-181 DataModel interacts with map-controller via either its UBUS API or UCI.

### TR-181 Dump

```
Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.ChannelScanRequest()
Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.ChannelScanRequest() input:ChannelList
Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.ChannelScanRequest() input:OpClass
Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.ChannelScanRequest() output:Status
Device.WiFi.DataElements.Network.SetPreferredBackhauls()
Device.WiFi.DataElements.Network.SetPreferredBackhauls() input:PreferredBackhauls.{i}.BackhaulMACAddress
Device.WiFi.DataElements.Network.SetPreferredBackhauls() input:PreferredBackhauls.{i}.bSTAMACAddress
Device.WiFi.DataElements.Network.SetPreferredBackhauls() output:Status
Device.WiFi.DataElements.Network.SetSSID()
Device.WiFi.DataElements.Network.SetSSID() input:AddRemove
Device.WiFi.DataElements.Network.SetSSID() input:Band
Device.WiFi.DataElements.Network.SetSSID() input:PassPhrase
Device.WiFi.DataElements.Network.SetSSID() input:SSID
Device.WiFi.DataElements.Network.SetSSID() output:Status
Device.WiFi.DataElements.Network.SetTrafficSeparation()
Device.WiFi.DataElements.Network.SetTrafficSeparation() input:Enable
Device.WiFi.DataElements.Network.SetTrafficSeparation() input:SSIDtoVIDMapping.{i}.SSID
Device.WiFi.DataElements.Network.SetTrafficSeparation() input:SSIDtoVIDMapping.{i}.VID
Device.WiFi.DataElements.Network.SetTrafficSeparation() output:Status
```


### API Table

| Object  		                                                    | API  | CMDU | Description	| Notes |
|---------------------------------------------------------------------------|------|------|-------------|-------|
|Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.ChannelScanRequest() | UBUS | Channel Scan Request | ubus call map.controller scan  ||
|Device.WiFi.DataElements.Network.SetPreferredBackhauls()        | UCI  | Backhaul Steer Request | Sets preferred backhaul of an agent, set per 'node' section from "backhaul_ul_macaddr/backhaul_dl_macaddr" | Not yet implemented |
|Device.WiFi.DataElements.Network.SetSSID() | UCI | AP-Autoconfiguration Renew, AP-Autoconfiguration WSC | Set SSID, key etc. per 'ap' section ||
|Device.WiFi.DataElements.Network.SetTrafficSeparation()  | UCI	 | Multi-AP Policy Config Request | Enable, disable (via 'controller' section) or set SSID-to-VID mapping (via 'ap' sections) ||
