/*
 * liblcrytpo.c - implements crytpographic function wrappers
 *
 * Copyright (C) 2025 iopsys Software Solutions AB. All rights reserved.
 *
 */

#include <string.h>
#include <openssl/evp.h>

#include "libcrypto.h"

bool update_sha256_hash(void *data, int length, uint8_t *sha256_out)
{
	bool ret = false;
	uint8_t new_sha256[SHA256_LENGTH] = {0};
	EVP_MD_CTX *ctx;

	ctx = EVP_MD_CTX_new();
	if (!ctx)
		return true;

	if (!EVP_DigestInit_ex(ctx, EVP_sha256(), NULL))
		goto error_cleanup;

	if (!EVP_DigestUpdate(ctx, data, length))
		goto error_cleanup;

	if (!EVP_DigestFinal_ex(ctx, new_sha256, NULL))
		goto error_cleanup;

	if (memcmp(sha256_out, new_sha256, SHA256_LENGTH)) {
		memcpy(sha256_out, new_sha256, SHA256_LENGTH);
		ret = true;
	}

error_cleanup:
	EVP_MD_CTX_free(ctx);
	return ret;
}
