#ifndef AUTOCONFIG_H
#define AUTOCONFIG_H

#include <stdbool.h>
#include <stdint.h>

#include "utils/libcrypto.h"

#define HEARTBEAT_AUTOCFG_INTERVAL 70

#define AUTOCFG_FILE "/etc/multiap/wsc_m2.json"

struct wifi_radio_element;

enum autocfg_state {
	AUTOCFG_HEARTBEAT,
	AUTOCFG_ACTIVE
};

enum autocfg_diff {
	DIFF_NONE     = 0,
	DIFF_WSC_M2   = 1 << 0,
#if (EASYMESH_VERSION >= 6)
	DIFF_AP_MLD   = 1 << 1,
	DIFF_BSTA_MLD = 1 << 2,
#endif
	DIFF_ERR      = 255,
};

struct wsc_data {
	uint8_t *m1_frame;
	uint16_t m1_size;
	struct wsc_key *key;
	uint8_t sha256[SHA256_LENGTH];
};

void autoconfig_clean_wsc_hash(struct wsc_data *wsc);
void autoconfig_update_wsc_hash(struct wsc_data *data, uint8_t *new_sha256);
int autoconfig_wsc_m2_diff(struct wifi_radio_element *re,
			  struct tlv *tlvs[][TLV_MAXNUM],
			  size_t tlvs_size,
			  uint8_t *wsc_m2_sha256);

int autoconfig_radio_hash_to_file(uint8_t *macaddr, uint8_t *sha256);
int autoconfig_radio_hash_from_file(uint8_t *macaddr, uint8_t *sha256_out);
#if (EASYMESH_VERSION >= 6)
int autoconfig_ap_mld_hash_to_file(uint8_t *sha256);
int autoconfig_ap_mld_hash_from_file(uint8_t *sha256_out);
int autoconfig_bsta_mld_hash_to_file(uint8_t *sha256);
int autoconfig_bsta_mld_hash_from_file(uint8_t *sha256_out);
#endif
#endif
