/*
 * agent_ubus.h - wifi agent's ubus object header
 *
 * Copyright (C) 2019 IOPSYS Software Solutions AB. All rights reserved.
 *
 * Author: anjan.chanda@iopsys.eu
 *
 */

#ifndef AGENT_UBUS_H
#define AGENT_UBUS_H

#include <timer_impl.h>
#include <libubus.h>

struct agent;
struct ubus_object;

typedef uint32_t wifi_object_t;

#define WIFI_OBJECT_INVALID	(0x0)


struct agent_async_request {
	char name[32];
	struct ubus_request ubus_req;
	void (*success_cb)(struct agent_async_request *);
	void (*timeout_cb)(atimer_t *);
	atimer_t timeout;
	struct list_head list;
};

int agent_publish_object(struct agent *a, const char *objname);
void agent_remove_object(struct agent *a, struct ubus_object *obj);
void agent_notify_event(struct agent *a, const void *ev_type, void *ev_data);
void agent_notify_iface_event(struct agent *a, void *ev_ifname,
		const char *ev_type, void *ev_data);
int ubus_call_object_args(struct ubus_context *ctx, wifi_object_t wobj,
			  struct blob_buf *bb, const char *method,
			  void (*response_cb)(struct ubus_request *, int, struct blob_attr *),
			  void *priv);
int ubus_call_object(struct ubus_context *ctx, wifi_object_t wobj, const char *method,
		void (*response_cb)(struct ubus_request *, int, struct blob_attr *), void *priv);
uint32_t ubus_get_object(struct ubus_context *ctx, const char *name);

int ubus_call_object_async(struct agent *a,
			   struct ubus_context *ctx, const char *objname,
			   uint32_t obj_id, const char *method,
			   void (*response_cb)(struct ubus_request *, int, struct blob_attr *),
			   void (*success_cb)(struct agent_async_request *),
			   void (*timeout_cb)(atimer_t *),
			   void *priv);
#endif /* AGENT_UBUS_H */
