#ifndef ZT_H
#define ZT_H
#if (EASYMESH_VERSION > 2)
#ifdef USE_LIBDPP
#ifdef ZEROTOUCH_DPP

#include <stddef.h>
#include <stdint.h>

struct zt_context {
	void *pubkey;
	uint8_t *encoded_frame;
	size_t encoded_framelen;

	char *passphrase;
	uint8_t *encoded_frame2;
	size_t encoded_framelen2;

	/* libztdpp functions */
	void *libztdpp;
	uint8_t *(*dpp_gen_encoded_uri_payload)(void *ap_pubkey, void *own_key, const char *uri, size_t *olen);
	uint8_t *(*dpp_gen_pa_vsie_frame)(uint8_t *payload, size_t len, size_t *olen);
	uint8_t *(*dpp_gen_encoded_uri_payload2)(char *, const char *, size_t *);
	uint8_t *(*dpp_gen_pa_vsie_frame2)(uint8_t *, size_t, size_t *);
};

int libztdpp_open(struct zt_context *zt);
void libztdpp_close(struct zt_context *zt);

int zt_init(struct zt_context *zt, char *bi_key, char *uri);
#endif
#endif
#endif
#endif
