/*
 * wifi_ubus.h - wifimngr ubus interface
 *
 * Copyright (C) 2022 IOPSYS Software Solutions AB. All rights reserved.
 *
 */

#ifndef WIFI_UBUS_H
#define WIFI_UBUS_H

#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>
#include <easy/utils.h>
#include <easy/if_utils.h>
#include <wifidefs.h>

struct netif_ap;
struct netif_bk;
struct ubus_context;
struct wifi_ap_status;
struct wifi_bsta_status;
struct wifi_radio_opclass;
struct wifi_radio_status;
struct wifi_request_neighbor_param;


int wifi_ubus_scan(struct ubus_context *ubus_ctx, const char *radio,
		   struct scan_param_ex *param,
		   int num_opclass, uint8_t *opclass,
		   int num_channel, uint8_t *channel);
int wifi_ubus_ap_set_state(struct ubus_context *ubus_ctx, const char *name, bool up);

int wifi_ubus_start_cac(struct ubus_context *ubus_ctx, const char *radio,
			int channel, enum wifi_bw bw, enum wifi_cac_method method);
int wifi_ubus_stop_cac(struct ubus_context *ubus_ctx, const char *radio, int channel, enum wifi_bw bw);
int wifi_ubus_del_neighbor(struct ubus_context *ubus_ctx, const char *ifname, uint8_t *bssid);
int wifi_ubus_add_neighbor(struct ubus_context *ubus_ctx, const char *ifname, struct nbr *nbr);
int wifi_ubus_list_neighbor(struct ubus_context *ubus_ctx, const char *ifname,
			    struct nbr *nbr, int *nbr_num);

int wifi_ubus_opclass_preferences(struct ubus_context *ubus_ctx, const char *radio,
				  struct wifi_radio_opclass *opclass);
int wifi_ubus_radio_status(struct ubus_context *ubus_ctx, const char *radio,
			   struct wifi_radio_status *status);
int wifi_ubus_disconnect_sta(struct ubus_context *ubus_ctx, const char *ifname,
			     uint8_t *macaddr, uint16_t reason);
int wifi_ubus_restrict_sta(struct ubus_context *ubus_ctx, struct netif_ap *ap,
			   uint8_t *macaddr, bool block_sta);
int wifi_ubus_get_restricted_stas(struct ubus_context *ubus_ctx,
				  struct netif_ap *ap, uint8_t *stas, int *num);
int wifi_ubus_req_btm(struct ubus_context *ubus_ctx, const char *name, uint8_t *macaddr,
				uint8_t pref_num, struct nbr *pref, struct wifi_btmreq *req);
int wifi_ubus_add_vendor_ie(struct ubus_context *ubus_ctx, const char *ifname, int mgmt,
			    char *oui, char *data);
int wifi_ubus_del_vendor_ie(struct ubus_context *ubus_ctx, const char *ifname, int mgmt,
			    char *oui, char *data);
int wifi_ubus_get_4addr(struct ubus_context *ubus_ctx, struct netif_bk *bk, bool *enable);
int wifi_ubus_set_4addr(struct ubus_context *ubus_ctx, const char *ifname, bool enable);

int wifi_ubus_ap_status(struct ubus_context *ubus_ctx, const char *ifname, struct wifi_ap_status *ap_status);
int wifi_ubus_radio_scanresults(struct ubus_context *ubus_ctx, const char *radio,
				struct wifi_bss *bss, int *num, bool cache);

int wifi_ubus_channels_info(struct ubus_context *ubus_ctx, const char *radio,
				struct chan_entry *ch_entry, int *num);

int wifi_ubus_monitor_add_del(struct ubus_context *ubus_ctx, const char *ifname,
			      uint8_t *macaddr, bool add);
int wifi_ubus_monitor_add(struct ubus_context *ubus_ctx, const char *ifname, uint8_t *macaddr);
int wifi_ubus_monitor_del(struct ubus_context *ubus_ctx, const char *ifname, uint8_t *macaddr);
int wifi_ubus_monitor_get(struct ubus_context *ubus_ctx, const char *ifname,
			  uint8_t *macaddr, struct wifi_monsta *monsta);

int wifi_ubus_chan_switch(struct ubus_context *ubus_ctx, const char *ifname,
			  struct chan_switch_param *param);
int wifi_ubus_get_assoclist(struct ubus_context *ubus_ctx, struct netif_ap *ap,
			   uint8_t *sta, int *num);
int wifi_ubus_req_neighbor(struct ubus_context *ubus_ctx, const char *ifname,
			   uint8_t *sta, struct wifi_request_neighbor_param *param);
int wifi_ubus_get_stations(struct ubus_context *ubus_ctx, struct netif_ap *ap,
			   struct wifi_sta *sta, int *num);
int wifi_ubus_get_station(struct ubus_context *ubus_ctx, struct netif_ap *ap,
			  uint8_t *sta_addr, struct wifi_sta *sta);
#if (EASYMESH_VERSION >= 6)
int wifi_ubus_get_mld_station(struct ubus_context *ubus_ctx, struct netif_ap *ap,
			  uint8_t *mld_addr, uint8_t *link_addr, struct wifi_mlsta *mlsta);
int wifi_ubus_get_mld_stations(struct ubus_context *ubus_ctx, struct netif_ap *ap,
			       struct wifi_mlsta *mlsta, int *num);
#endif
int wifi_ubus_bsta_disconnect(struct ubus_context *ubus_ctx, struct netif_bk *bk,
				uint32_t reason);
int wifi_ubus_subscribe_frame(struct ubus_context *ubus_ctx, const char *ifname,
			      uint8_t type, uint8_t stype);
int wifi_ubus_unsubscribe_frame(struct ubus_context *ubus_ctx, const char *ifname,
				uint8_t type, uint8_t stype);
int wifi_ubus_ap_stats(struct ubus_context *ubus_ctx, const char *ifname,
		       struct wifi_ap_stats *stats);
int wifi_ubus_bsta_status(struct ubus_context *ubus_ctx, const char *ifname,
			  struct wifi_bsta_status *bsta_status);
int wifi_ubus_ap_mbo_disallow_assoc(struct ubus_context *ubus_ctx,
				    const char *ifname, bool allow);
int wifi_ubus_send_action(struct ubus_context *ubus_ctx, const char *ifname, uint8_t *dst_mac,
				uint8_t *src_mac, uint32_t wait, uint32_t freq, const uint8_t *bytes, int len);
int wifi_ubus_initiate_wpspbc(struct ubus_context *ubus_ctx, const char *ifname, bool is_bsta);
#if (EASYMESH_VERSION > 2)
int wifi_ubus_set_qos_map(struct ubus_context *ubus_ctx, const char *ifname,
                          uint8_t *qos_map, size_t qos_map_len);
int wifi_ubus_send_qos_map_conf(struct ubus_context *ubus_ctx, const char *ifname,
                                uint8_t *macaddr);

#ifdef USE_LIBDPP
int wifi_ubus_ap_send_actframe(struct ubus_context *ubus_ctx,
			       const char *ifname, uint8_t *dst, uint8_t *frame,
			       size_t framelen, uint32_t freq, bool hostapd);
int wifi_ubus_dpp_listen(struct ubus_context *ubus_ctx,
			    const char *ifname, uint32_t freq, bool hostapd);
int wifi_ubus_dpp_stop_listen(struct ubus_context *ubus_ctx,
				 const char *ifname, bool hostapd);
#endif
#endif
#endif /* WIFI_UBUS_H */
