/*
 * cmdu_extension.h - CMDU extension header (not for export)
 *
 * Copyright (C) 2023 IOPSYS Software Solutions AB. All rights reserved.
 *
 * Author: anjan.chanda@iopsys.eu
 *
 * See LICENSE file for license related information.
 *
 */

#ifndef CMDU_EXTENSION_H
#define CMDU_EXTENSION_H

#include "extension.h"

#ifdef __cplusplus
extern "C" {
#endif

#define cmdu_rx_mask_isset(m, f) \
({ \
	(!!(m[(f >= 0x8000 ? 32 : 0) + (f >= 0x8000 ? f - 0x8000 : f)].type == f) &&         \
	 !!(m[(f >= 0x8000 ? 32 : 0) + (f >= 0x8000 ? f - 0x8000 : f)].loc & CMDU_RX));      \
})

#define cmdu_pre_tx_mask_isset(m, f) \
({ \
	(!!(m[(f >= 0x8000 ? 32 : 0) + (f >= 0x8000 ? f - 0x8000 : f)].type == f) &&         \
	 !!(m[(f >= 0x8000 ? 32 : 0) + (f >= 0x8000 ? f - 0x8000 : f)].loc & CMDU_PRE_TX));  \
})

void cmdu_print_extension_mask(cmdu_extend_mask_t mask);

#ifdef __cplusplus
}
#endif

#endif /* CMDU_EXTENSION_H */
