/*
 * timeutils.h
 * Header file for time utility functions.
 *
 * Copyright (C) 2025 Genexis Sweden AB. All rights reserved.
 *
 * See LICENSE file for license related information.
 *
 */

#ifndef TIMEUTILS_H
#define TIMEUTILS_H

#include <stdbool.h>
#include <time.h>

struct timespec;

bool timestamp_less_than(const struct timespec *lhs, const struct timespec *rhs);
bool timestamp_greater_than(const struct timespec *lhs, const struct timespec *rhs);
bool timestamp_greater_or_equal(const struct timespec *lhs, const struct timespec *rhs);
bool timestamp_less_or_equal(const struct timespec *lhs, const struct timespec *rhs);

char *time_to_timestamp(const time_t *t, char *tsp);
time_t timestamp_to_time(const char *tsp);

#endif /* TIMEUTILS_H */
