#ifndef MAPAGENT_QOS_INTERNAL_H
#define MAPAGENT_QOS_INTERNAL_H

#if (EASYMESH_VERSION > 2)

#include <easymesh.h>
#include <libubox/list.h>

/* Rule types */
enum qos_rule_type {
	QOS_RULE_TYPE_DSCP_PCP,/**< DSCP policy type */
	QOS_RULE_TYPE_MSCS,    /**< MSCS rule */
	QOS_RULE_TYPE_SCS,     /**< SCS rule */
	QOS_RULE_TYPE_MGMT,    /**< Management rule */
};

/* Rule structure which contains both SPR and DSCP parts */
struct qos_rule {
	struct list_head        list;  /**< List head */
	struct tlv_spr          spr;   /**< Service Prioritization Rule */
	enum   qos_rule_type    type;  /**< Rule Type */
	union {
		struct tlv_dscp_pcp dscp;  /**< DSCP rule - valid only in case of
		                                QOS_RULE_TYPE_DSCP_PCP rule type */
	};
};

/* DSCP-PCP -> hostapd format conversion results */
enum dscp_pcp_conv_result {
	DSCP_PCP_CONV_RESULT_OK,               /**< Conversion finished well */
	DSCP_PCP_CONV_RESULT_OK_TOO_MANY_EXC,  /**< Conversion finished well,
	                                            but too many exceptions */
	DSCP_PCP_CONV_RESULT_TOO_LONG,         /**< Too long result that didn't
	                                            fit the output buffer */
	DSCP_PCP_CONV_RESULT_FAIL,             /**< Failure producing QoS map */
};

#endif

#endif
