#ifdef DYNBH
#ifdef PERSIST_CONTROLLER
#include "dynbh_config.h"

#include <stdbool.h>
#include <string.h>

#include "dynbh.h"
#include "config.h"

int dynbh_config_set_controller_select(enum cntlr_discovery_mode mode,
				     bool autostart, bool local)
{
	struct uci_context *ctx;
	struct uci_package *pkg;
	struct uci_element *e;


	ctx = uci_alloc_context();
	if (!ctx)
		return -1;

	if (uci_load(ctx, "mapagent", &pkg)) {
		uci_free_context(ctx);
		return -1;
	}

	uci_foreach_element(&pkg->sections, e) {
		struct uci_section *s = uci_to_section(e);

		if (strcmp(s->type, "controller_select"))
			continue;

		set_value(ctx, pkg, s, "mode", dynbh_mode_to_str(mode), UCI_TYPE_STRING);
		set_value(ctx, pkg, s, "autostart", (autostart ? "1" : "0"), UCI_TYPE_STRING);
		set_value(ctx, pkg, s, "local", (local ? "1" : "0"), UCI_TYPE_STRING);
	}

	uci_commit(ctx, &pkg, false);
	uci_unload(ctx, pkg);
	uci_free_context(ctx);
	return 0;
}
#endif
#endif
