
#ifndef AGENT_MAP_H
#define AGENT_MAP_H

#include <stdbool.h>
#include <stdint.h>

struct agent;
struct channel_response;  // lines 8-8
struct cmdu_buff;
struct netif_bk;
struct netif_ap;
struct node;
struct sta_error_response;
struct timespec;
struct tlv_channel_pref;
struct tlv_unassoc_sta_link_metrics_query;
struct wifi_unassoc_sta_element;
struct wifi_netdev;
struct wifi_radio_element;
struct wifi_scanresults;

#define RCPI_THRESHOLD_TIMER	(5 * 1000)
#define RADIO_STATS_TIMER	(1 * 1000)

/** enum bssid informatino field - bit-flags */
enum bssid_information {
	BSSID_INFO_REACHABILITY_B0,
	BSSID_INFO_REACHABILITY_B1,
	BSSID_INFO_SECURITY,
	BSSID_INFO_KEY_SCOPE,

	BSSID_INFO_CAP_SPECTRUM_MGMT,
	BSSID_INFO_CAP_WMM,
	BSSID_INFO_CAP_APSD,
	BSSID_INFO_CAP_RADIO_MEAS,
	BSSID_INFO_CAP_DELAYED_BA,
	BSSID_INFO_CAP_IMMEDIATE_BA,

	BSSID_INFO_MOBILITY_DOMAIN,
	BSSID_INFO_HT,
	BSSID_INFO_VHT,
	BSSID_INFO_FMT,

	BSSID_INFO_AFTER_LAST,
	BSSID_INFO_MAX = BSSID_INFO_AFTER_LAST - 1
};

#define agent_bssid_info_set(b, f) ((b) |= (1 << (f)))

/**
 * @enum topology_discovery_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum topology_discovery_tlvs_order {
	TOPOLOGY_DISCOVERY_AL_MAC_ADDR_TYPE_IDX = 0,
	TOPOLOGY_DISCOVERY_MAC_ADDR_TYPE_IDX,

	TOPOLOGY_DISCOVERY_NUM_OF_TLV_TYPES
};

/**
 * @enum topology_notification_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum topology_notification_tlvs_order {
	TOPOLOGY_NOTIFICATION_MAC_ADDR_TYPE_IDX, // 0
	TOPOLOGY_NOTIFICATION_CLIENT_ASSOCIATION_EVENT_IDX,

	TOPOLOGY_NOTIFICATION_NUM_OF_TLV_TYPES
};

/**
 * @enum topology_response_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum topology_response_tlvs_order {
	TOPOLOGY_RESPONSE_DEVICE_INFORMATION_TYPE_IDX = 0,
	TOPOLOGY_RESPONSE_DEVICE_BRIDGING_CAPABILITIES_IDX,
	TOPOLOGY_RESPONSE_NON_1905_NEIGHBOR_DEVICE_LIST_IDX,
	TOPOLOGY_RESPONSE_NEIGHBOR_DEVICE_LIST_IDX,
	TOPOLOGY_RESPONSE_POWER_OFF_INTERFACE_IDX,
	TOPOLOGY_RESPONSE_L2_NEIGHBOR_DEVICE_IDX,
	TOPOLOGY_RESPONSE_SUPPORTED_SERVICE_IDX,
	TOPOLOGY_RESPONSE_AP_OPERATIONAL_BSS_IDX,
	TOPOLOGY_RESPONSE_ASSOCIATED_CLIENTS_IDX = 8,
#if (EASYMESH_VERSION >= 2)
	TOPOLOGY_RESPONSE_MULTIAP_PROFILE_IDX = 9,
#if (EASYMESH_VERSION >= 3)
	TOPOLOGY_RESPONSE_BSS_CONFIGURATION_REPORT_IDX = 10,
#if (EASYMESH_VERSION >= 6)
	TOPOLOGY_RESPONSE_BACKHAUL_STA_RADIO_CAPABILITY_IDX = 11,
	TOPOLOGY_RESPONSE_AP_MLD_CONFIG_IDX,
	TOPOLOGY_RESPONSE_BACKHAUL_STA_MLD_CONFIG_IDX,
	TOPOLOGY_RESPONSE_STA_MLD_CONFIG_IDX,
	TOPOLOGY_RESPONSE_TID_TO_LINK_MAPPING_POLICY_IDX,
#endif
#endif
#endif

	TOPOLOGY_RESPONSE_NUM_OF_TLV_TYPES
};

/**
 * @enum ap_autoconfiguration_search_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum ap_autoconfiguration_search_tlvs_order {

	AP_AUTOCONFIGURATION_SEARCH_AL_MAC_ADDRESS_TYPE_IDX = 0,
	AP_AUTOCONFIGURATION_SEARCH_SEARCHED_ROLE_IDX,
	AP_AUTOCONFIGURATION_SEARCH_AUTOCONFIG_FREQ_BAND_IDX,
	AP_AUTOCONFIGURATION_SEARCH_SUPPORTED_SERVICE_IDX,
	AP_AUTOCONFIGURATION_SEARCH_SEARCHED_SERVICE_IDX,
#if (EASYMESH_VERSION >= 2)
	AP_AUTOCONFIGURATION_SEARCH_MULTIAP_PROFILE_IDX = 5,
#if (EASYMESH_VERSION >= 3)
	AP_AUTOCONFIGURATION_SEARCH_DPP_CHIRP_VALUE_IDX	= 6,
#endif
#endif

	AP_AUTOCONFIGURATION_SEARCH_NUM_OF_TLV_TYPES
};

/**
 * @enum ap_autoconfiguration_response_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum ap_autoconfiguration_response_tlvs_order {
	AP_AUTOCONFIGURATION_RESP_SUPPORTED_ROLE_IDX = 0,
	AP_AUTOCONFIGURATION_RESP_SUPPORTED_FREQ_BAND,
	AP_AUTOCONFIGURATION_RESP_SUPPORTED_SERVICE_IDX,
#if (EASYMESH_VERSION >= 2)
	AP_AUTOCONFIGURATION_RESP_MULTIAP_PROFILE_IDX = 3,
#if (EASYMESH_VERSION >= 3)
	AP_AUTOCONFIGURATION_RESP_1905_SECURITY_CAPS_IDX = 4,
	AP_AUTOCONFIGURATION_RESP_DPP_CHIRP_VALUE_IDX,
#if (EASYMESH_VERSION >= 4)
	AP_AUTOCONFIGURATION_RESP_CONTROLLER_CAPS_IDX = 6,
#endif
#endif
#endif

	AP_AUTOCONFIGURATION_RESP_NUM_OF_TLV_TYPES
};

/**
 * @enum ap_autoconfiguration_wsc_m2_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum ap_autoconfiguration_wsc_m2_tlvs_order {
	AP_AUTOCONFIGURATION_WSC_M2_AP_RADIO_IDENTIFIER_IDX = 0,
	AP_AUTOCONFIGURATION_WSC_M2_WSC_IDX,
	AP_AUTOCONFIGURATION_WSC_M2_DEFAULT_8021Q_SETTINGS_IDX,
	AP_AUTOCONFIGURATION_WSC_M2_TRAFFIC_SEPARATION_POLICY_IDX,
#if (EASYMESH_VERSION >= 6)
	AP_AUTOCONFIGURATION_WSC_M2_AP_MLD_CONFIG_IDX = 4,
	AP_AUTOCONFIGURATION_WSC_M2_BACKHAUL_STA_MLD_CONFIG_IDX,
#endif

	AP_AUTOCONFIGURATION_WSC_M2_NUM_OF_TLV_TYPES
};

/**
 * @enum ap_autoconfiguration_renew_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum ap_autoconfiguration_renew_tlvs_order {
	AP_AUTOCONFIGURATION_RENEW_AL_MAC_ADDRESS_TYPE_IDX = 0,
	AP_AUTOCONFIGURATION_RENEW_SUPPORTED_ROLE_IDX,
	AP_AUTOCONFIGURATION_RENEW_SUPPORTED_FREQ_BAND_IDX,

	AP_AUTOCONFIGURATION_RENEW_NUM_OF_TLV_TYPES
};

/**
 * @enum ap_capability_report_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum ap_capability_report_tlvs_order {
	AP_CAPABILITY_REPORT_AP_CAPABILITY_IDX = 0,
	AP_CAPABILITY_REPORT_AP_RADIO_BASIC_CAPS_IDX,
	AP_CAPABILITY_REPORT_AP_HT_CAPS_IDX,
	AP_CAPABILITY_REPORT_AP_VHT_CAPS_IDX,
	AP_CAPABILITY_REPORT_AP_HE_CAPS_IDX,
#if (EASYMESH_VERSION >= 2)
	AP_CAPABILITY_REPORT_CHANNEL_SCAN_CAPABILITY_IDX = 5,
	AP_CAPABILITY_REPORT_CAC_CAPABILITY_IDX,
	AP_CAPABILITY_REPORT_PROFILE2_AP_CAPABILITY_IDX,
	AP_CAPABILITY_REPORT_METRIC_COLLECTION_INTERVAL_IDX,
#if (EASYMESH_VERSION >= 3)
	AP_CAPABILITY_REPORT_AP_WIFI6_CAPS_IDX = 9,
	AP_CAPABILITY_REPORT_1905_SECURITY_CAPS_IDX,
	AP_CAPABILITY_REPORT_DEVICE_INVENTORY_IDX,
#if (EASYMESH_VERSION >= 4)
	AP_CAPABILITY_REPORT_AP_RADIO_ADV_CAPABILITY_IDX = 12,
#if (EASYMESH_VERSION >= 6)
	AP_CAPABILITY_REPORT_AKM_SUITE_CAPS_IDX = 13,
	AP_CAPABILITY_REPORT_WIFI7_AGENT_CAPS_IDX,
	AP_CAPABILITY_REPORT_EHT_OPERATIONS_IDX,
#endif
#endif
#endif
#endif

	AP_CAPABILITY_REPORT_NUM_OF_TLV_TYPES
};

/**
 * @enum map_policy_config_req_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum map_policy_config_req_tlvs_order {
	MAP_POLICY_CONFIG_REQ_STEERING_POLICY_IDX = 0,
	MAP_POLICY_CONFIG_REQ_METRIC_REPORTING_POLICY_IDX,
	MAP_POLICY_CONFIG_REQ_DEFAULT_8021Q_SETTINGS_IDX,
	MAP_POLICY_CONFIG_REQ_TRAFFIC_SEPARATION_POLICY_IDX,
	MAP_POLICY_CONFIG_REQ_CHANNEL_SCAN_REPORTING_POLICY_IDX,
	MAP_POLICY_CONFIG_REQ_UNSUCCESS_ASSOCIATION_POLICY_IDX,
	MAP_POLICY_CONFIG_REQ_BACKHAUL_BSS_CONFIG_IDX,
	MAP_POLICY_CONFIG_REQ_QOS_MANAGEMENT_POLICY_IDX,

	MAP_POLICY_CONFIG_REQ_NUM_OF_TLV_TYPES
};

/**
 * @enum ap_metrics_query_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum ap_metrics_query_tlvs_order {
	AP_METRICS_QUERY_AP_METRIC_QUERY_IDX = 0,
	AP_METRICS_QUERY_AP_RADIO_IDENTIFIER_IDX,

	AP_METRICS_QUERY_NUM_OF_TLV_TYPES
};

/**
 * @enum operating_channel_report_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum operating_channel_report_tlvs_order {
	OPER_CHANNEL_REPORT_OPERATING_CHANNEL_IDX = 0,
#if (EASYMESH_VERSION >= 4)
	OPER_CHANNEL_REPORT_SPATIAL_REUSE_IDX =	1,
#if (EASYMESH_VERSION >= 6)
	OPER_CHANNEL_REPORT_EHT_OPERATIONS_IDX = 2,
#endif
#endif

	OPER_CHANNEL_REPORT_NUM_OF_TLV_TYPES
};
/**
 * @enum client_capability_query_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum client_capability_query_tlvs_order {
	CLIENT_CAPABILITY_QUERY_CLIENT_INFO_IDX = 0,

	CLIENT_CAPABILITY_QUERY_NUM_OF_TLV_TYPES
};

/**
 * @enum link_metric_response_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum link_metric_response_tlvs_order {
	LINK_METRICS_RESP_TRANSMITTER_LINK_METRICS_IDX = 0,
	LINK_METRICS_RESP_RECEIVER_LINK_METRICS_IDX,

	LINK_METRICS_RESP_NUM_OF_TLV_TYPES
};

/**
 * @enum assoc_sta_link_metrics_query_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum assoc_sta_link_metrics_query_tlvs_order {
	ASSOC_STA_LINK_METRICS_QUERY_STA_MAC = 0,

	ASSOC_STA_LINK_METRICS_QUERY_NUM_OF_TLV_TYPES
};

/**
 * @enum unassoc_sta_link_metrics_query_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum unassoc_sta_link_metrics_query_tlvs_order {
	UNASSOC_STA_LINK_METRICS_QUERY = 0,

	UNASSOC_STA_LINK_METRICS_QUERY_NUM_OF_TLV_TYPES
};

/**
 * @enum beacon_metrics_query_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum beacon_metrics_query_tlvs_order {
	BEACON_METRICS_QUERY = 0,

	BEACON_METRICS_QUERY_NUM_OF_TLV_TYPES
};

/**
 * @enum client_steering_request_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum client_steering_request_tlvs_order {
	CLIENT_STEERING_REQUEST_STEERING_REQUEST_IDX = 0,
#if (EASYMESH_VERSION >= 2)
	CLIENT_STEERING_REQUEST_PROFILE2_STEERING_REQ_IDX,
#endif

	CLIENT_STEERING_REQUEST_NUM_OF_TLV_TYPES
};

/**
 * @enum client_association_control_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum client_association_control_tlvs_order {
	CLIENT_ASSOC_CONTROL_REQUEST_IDX = 0,

	CLIENT_ASSOC_CONTROL_NUM_OF_TLV_TYPES
};

/**
 * @enum higher_layer_data_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum higher_layer_data_tlvs_order {
	HIGHER_LAYER_DATA_HLD_IDX = 0,

	HIGHER_LAYER_DATA_NUM_OF_TLV_TYPES
};

/**
 * @enum backhaul_steering_request_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum backhaul_steering_request_tlvs_order {
	BACKHAUL_STEERING_REQUEST_IDX = 0,

	BACKHAUL_STEERING_NUM_OF_TLV_TYPES
};

/**
 * @enum channel_scan_request_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum channel_scan_request_tlvs_order {
	CHAN_SCAN_REQ_CHANNEL_SCAN_REQ_IDX = 0,

	CHAN_SCAN_REQ_NUM_OF_TLV_TYPES
};

/**
 * @enum channel_scan_report_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum channel_scan_report_tlvs_order {
	CHAN_SCAN_REPORT_TIMESTAMP_IDX = 0,
	CHAN_SCAN_REPORT_CHANNEL_SCAN_RES_IDX,
#if (EASYMESH_VERSION >= 6)
	CHAN_SCAN_REPORT_MLD_STRUCTURE_IDX = 2,
#endif

	CHAN_SCAN_REPORT_NUM_OF_TLV_TYPES
};

/**
 * @enum cac_request_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum cac_request_tlvs_order {
	CAC_REQUEST_CAC_REQ_IDX = 0,

	CAC_REQUEST_NUM_OF_TLV_TYPES
};

/**
 * @enum cac_termination_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum cac_termination_tlvs_order {
	CAC_TERMINATION_CAC_TERMINATION_IDX = 0,

	CAC_TERMINATION_NUM_OF_TLV_TYPES
};

#if (EASYMESH_VERSION >= 3)
/**
 * @enum service_prioritization_request_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum service_prioritization_request_tlvs_order {
	SERVICE_PRIORITIZATION_REQUEST_SERVICE_PRIORITIZATION_RULE_IDX = 0,
	SERVICE_PRIORITIZATION_REQUEST_DSCP_MAPPING_TABLE_IDX,
#if (EASYMESH_VERSION >= 4)
	SERVICE_PRIORITIZATION_REQUEST_QOS_MANAGEMENT_DESCRIPTOR_IDX = 2,
#if (EASYMESH_VERSION >= 6)
	SERVICE_PRIORITIZATION_REQUEST_TID_TO_LINK_MAPPING_POLICY_IDX = 3,
#endif
#endif

	SERVICE_PRIORITIZATION_REQUEST_NUM_OF_TLV_TYPES
};

/**
 * @enum proxied_encap_dpp_tlvs_order
 * @brief specifies order of output TLVs and max. number of different TLVs
 */
enum proxied_encap_dpp_tlvs_order {
	PROXIED_ENCAP_1905_ENCAP_DPP_IDX = 0,
	PROXIED_ENCAP_CHIRP_VALUE_IDX,

	PROXIED_ENCAP_DPP_NUM_OF_TLV_TYPES
};

/**
 * @enum direct_encap_dpp_tlvs_order
 * @brief specifies order of output TLVs and max. number of different TLVs
 */
enum direct_encap_dpp_tlvs_order {
	DIRECT_ENCAP_DPP_MESSAGE_IDX = 0,

	DIRECT_ENCAP_DPP_NUM_OF_TLV_TYPES
};

/**
 * @enum agent_list_tlvs_order
 * @brief specifies order of output TLVs and max. number of different TLVs
 */
enum agent_list_tlvs_order {
	AGENT_LIST_AGENT_LIST_IDX = 0,

	AGENT_LIST_NUM_OF_TLV_TYPES
};

/**
 * @enum bss_configuration_response_tlvs_order
 * @brief specifies order of output TLVs and max. number of different TLVs
 */
enum bss_configuration_response_tlvs_order {
	BSS_CFG_RESP_BSS_CONFIG_RESPONSE_IDX = 0,
	BSS_CFG_RESP_DEFAULT_8021Q_SETTINGS_IDX,
	BSS_CFG_RESP_TRAFFIC_SEPARATION_POLICY_IDX,
#if (EASYMESH_VERSION >= 6)
	BSS_CFG_RESP_AP_MLD_CONFIG_IDX,
	BSS_CFG_RESP_BACKHAUL_STA_MLD_CONFIG_IDX,
	BSS_CFG_RESP_EHT_OPERATIONS_IDX,
#endif

	BSS_CFG_RESP_NUM_OF_TLV_TYPES
};

/**
 * @enum dpp_bootstraping_uri_notification_tlvs_order
 * @brief specifies order of output TLVs and max. number of different TLVs
 */
enum dpp_bootstraping_uri_notification_tlvs_order {
	DPP_BOOTSTRAP_URI_NOTIF_IDX = 0,

	DPP_BOOTSTRAP_URI_NOTIF_NUM_OF_TLV_TYPES
};

/**
 * @enum dpp_cce_indication_tlvs_order
 * @brief specifies order of output TLVs and max. number of different TLVs
 */
enum dpp_cce_indication_tlvs_order {
	DPP_CCE_INDICATION_IDX = 0,

	DPP_CCE_INDICATION_NUM_OF_TLV_TYPES
};
#endif

#if (EASYMESH_VERSION >= 6)
/**
 * @enum cmdu_ap_mld_config_request_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum cmdu_ap_mld_config_request_tlvs_order {
	AP_MLD_CONFIG_REQUEST_AP_MLD_CONFIG_IDX = 0,
	AP_MLD_CONFIG_REQUEST_EHT_OPERATIONS_IDX,

	AP_MLD_CONFIG_REQUEST_NUM_OF_TLV_TYPES
};

/**
 * @enum cmdu_bsta_mld_config_request_tlvs_order
 * @brief specifies order of output TLVs and max number of different TLVs
 */
enum cmdu_bsta_mld_config_request_tlvs_order {
	BSTA_MLD_CONFIG_REQUEST_BSTA_MLD_CONFIG_IDX = 0,

	BSTA_MLD_CONFIG_REQUEST_NUM_OF_TLV_TYPES
};
#endif

extern bool is_cmdu_for_us(struct agent *a, uint16_t type);

extern int agent_handle_map_cmd(struct agent *a, char *data, int len);

int agent_handle_map_event(struct agent *a, uint16_t cmdutype, uint16_t mid,
	char *rxif, uint8_t *src, uint8_t *origin, uint8_t *tlvs, int len);
int agent_get_highest_preference(struct wifi_radio_element *radio,
		uint32_t op_class_id, uint32_t *channel,
		uint32_t *opclass_to_move);
int agent_channel_switch(struct agent *a, uint8_t *radio_id, int channel,
		int opclass);
int agent_set_channel_preference_to_default(struct wifi_radio_element *radio);

int send_ap_metrics_response(void *agent, struct cmdu_buff *rx_cmdu,
			     struct node *n);
struct cmdu_buff *prepare_ap_metrics_query(void *agent, struct netif_ap *ap);

char *wifi_gen_first_ifname(struct agent *a, char *device, char *ifname);
struct netif_ap *wifi_get_available_ifname_with_ssid(struct agent *a, struct wifi_radio_element *re,
					char *ssid, char *ifname);
struct netif_ap *wifi_get_first_available_ifname(struct agent *a, struct wifi_radio_element *re, char *ifname);


uint16_t agent_send_cmdu(struct agent *a, struct cmdu_buff *cmdu);
int send_channel_sel_response(void *agent, struct cmdu_buff *cmdu,
		struct channel_response *rec_cmdu, uint32_t channel_response_nr);
int agent_fill_radio_max_preference(void *agent,
		struct channel_response *channel_resp, uint32_t *channel_response_nr);
int agent_process_channel_pref_tlv(void *agent, struct tlv_channel_pref  *p,
		struct channel_response *channel_resp,
		uint32_t *channel_response_nr);
int send_steer_btm_report(void *agent, uint8_t *origin,
		uint8_t *target_bssid, uint8_t *src_bssid,
		uint8_t *sta, uint8_t status_code);
int send_beacon_metrics_response(void *agent, uint8_t *sta_addr,
		uint8_t report_elems_nr, uint8_t *report_elem,
		uint16_t elem_len);
int send_backhaul_sta_steer_response(void *agent, struct netif_bk *bk,
				     char *ul_ifname);
int send_topology_query(void *agent, uint8_t *origin);
int send_oper_channel_report(void *agent, struct cmdu_buff *rx_cmdu);
int send_sta_steer_complete(void *agent, uint8_t *origin);
#if (EASYMESH_VERSION > 2)
int send_bss_configuration_request(struct agent *agent);
#endif
uint16_t agent_send_cmdu_unish(struct agent *a, struct cmdu_buff *cmdu);
int send_1905_acknowledge(void *agent, uint8_t *origin, uint16_t mid,
		struct sta_error_response *sta_resp, uint32_t sta_count);
int send_failed_connection_msg(void *agent, uint8_t *sta, int status_code, int reason_code);
int send_assoc_status_notification(struct agent *a, int num_data, void *data);
int send_unassoc_sta_link_metrics_response(void *agent, int num_metrics,
			struct wifi_unassoc_sta_element *metrics, uint8_t opclass);

int agent_apply_traffic_separation(struct agent *a);
int agent_disable_traffic_separation(struct agent *a);
bool agent_is_ts_enabled(struct agent *a);

int wifi_radio_update_opclass_preferences(struct agent *a, struct wifi_radio_element *re, bool send_report);
void update_neighbor_params(struct agent *a, uint8_t *bssid,
		uint8_t classid, uint8_t channel, const struct timespec *tsp);
#if (EASYMESH_VERSION > 2)
int handle_agent_list(void *agent, struct cmdu_buff *cmdu, struct node *n);
#endif
#if (EASYMESH_VERSION >= 3)
int handle_service_prioritization_request(void *agent, struct cmdu_buff *cmdu, struct node *n);
#endif
#if (EASYMESH_VERSION >= 4)
int handle_qos_management_notification(void *agent, struct cmdu_buff *cmdu, struct node *n);
#endif

int agent_set_link_profile(struct agent *a, struct node *n,
			   struct cmdu_buff *cmdu);
struct tlv_channel_scan_request *alloc_channel_scan_req(struct cmdu_buff *req_cmdu,
		uint8_t map_profile);

#endif /* AGENT_MAP_H */
