#!/bin/bash

echo "install dependencies"

home=$(pwd)

function exec_cmd()
{
	echo "executing $@"
	$@ >/dev/null 2>&1
	local ret=$?

	if [ "${ret}" -ne 0 ]; then
		echo "Failed to execute $@ ret (${ret})"
		exit 1
	fi
}

exec_cmd apt update
exec_cmd apt install -y iproute2

# libwifi-*.so + libeasy.so
cd /opt/dev
rm -fr libeasy
mkdir -p /usr/include/easy
exec_cmd git clone -b release-7.5 https://dev.iopsys.eu/iopsys/libeasy.git
cd libeasy
exec_cmd cmake .
exec_cmd make CFLAGS+="-I/usr/include/libnl3"
exec_cmd mkdir -p /usr/include/easy
exec_cmd cp easy.h event.h utils.h if_utils.h debug.h hlist.h bufutil.h cryptutil.h ecc_cryptutil.h timestamp.h /usr/include/easy
exec_cmd cp -a libeasy*.so* /usr/lib


cd /opt/dev
rm -fr libwifi
exec_cmd git clone -b release-7.5 https://dev.iopsys.eu/iopsys/libwifi.git
cd libwifi
exec_cmd make WIFI_TYPE=TEST CFLAGS+="-DHAS_WIFI=1"
exec_cmd cp wifidefs.h wifiutils.h wifiops.h wifi.h /usr/include
exec_cmd cp -a libwifi*.so* /usr/lib

# libdpp
cd /opt/dev
rm -fr libdpp
exec_cmd git clone -b release-7.5 https://dev.iopsys.eu/multi-ap/libdpp.git
cd libdpp/lib
exec_cmd make
exec_cmd cp -a libdpp*.so* /usr/lib
exec_cmd cp dpputils.h dpp_api.h dpp_sm.h json_helper.h timer.h utf8.h /usr/include

# wifimngr
cd /opt/dev
rm -fr wifimngr
exec_cmd git clone -b release-7.5 https://dev.iopsys.eu/iopsys/wifimngr.git
cd wifimngr
exec_cmd ./gitlab-ci/install-dependencies.sh
exec_cmd ./gitlab-ci/setup.sh
exec_cmd make
exec_cmd cp wifimngr /usr/sbin/

# ieee1905 + map.so
cd /opt/dev
rm -fr ieee1905
exec_cmd git clone --depth 1 -b release-7.5 https://dev.iopsys.eu/iopsys/ieee1905.git
cd ieee1905
cd src
CFLAGS+="-DDYNAMIC_CNTLR_SYNC_CONFIG -DHAS_UBUS -DEXTENSION_ALLOWED -DEASYMESH_VERSION=6" make
mkdir -p /usr/include /usr/lib/ieee1905
exec_cmd cp -a cmdu.h /usr/include/
exec_cmd cp -a cmdu_ackq.h /usr/include/
exec_cmd cp -a 1905_tlvs.h /usr/include/
exec_cmd cp -a i1905_wsc.h /usr/include/
exec_cmd cp -a timer_impl.h /usr/include/
exec_cmd cp -a libmidgen.so /usr/lib
exec_cmd cp -a libieee1905.so /usr/lib
exec_cmd cp -a ieee1905d /usr/sbin/
exec_cmd cp -a extensions/map/libmaputil.so /usr/lib
exec_cmd cp -a extensions/map/map.so /usr/lib
exec_cmd cp -a extensions/map/map_module.h /usr/include/
exec_cmd cp -a extensions/map/cntlrsync.h /usr/include/
exec_cmd cp -a extensions/map/easymesh.h /usr/include/

ldconfig
