#ifndef VENDOR_H
#define VENDOR_H

#ifdef EASYMESH_VENDOR_EXT
#include <1905_tlvs.h>

#ifndef EASYMESH_VENDOR_EXT_OUI_DEFAULT
#define EASYMESH_VENDOR_EXT_OUI_DEFAULT		0xB456FA  /* IOPSYS OUI */
#endif

/* Vendor TLV types supported by our implementation */
enum tlv_vendor_type_impl {
	TLV_VENDOR_TYPE_IMPL_UNSPEC = 0,
	TLV_VENDOR_TYPE_IMPL_PROBE_REQ = 1, /* Probe Requests */
	TLV_VENDOR_TYPE_IMPL_DISASSOCIATE_STA = 2, /* Disassociate STA */
	TLV_VENDOR_TYPE_IMPL_RESET_AGENT = 3, /* Reset agent's MultiAP stack */
};

/* Vendor TLV structure for our implementation */
struct tlv_vendor_impl {
	struct tlv_vendor_specific vendor;
	uint8_t vendor_type; /* Belongs to tlv_vendor_type_impl enumeration */
} __attribute__((packed));

struct tlv_vendor_disassociate_sta {
	struct tlv_vendor_impl vendor_impl;
	uint8_t macaddr[6];
	uint16_t reason;
} __attribute__((packed));

struct tlv_vendor_probe_req {
	struct tlv_vendor_impl vendor_impl;
	uint8_t macaddr[6];
	uint8_t bssid[6];
	uint8_t rcpi;
} __attribute__((packed));

struct tlv_vendor_reset_agent {
	struct tlv_vendor_impl vendor_impl;
} __attribute__((packed));

int agent_gen_vendor_specific_probe_req_tlv(struct agent *a,
		struct cmdu_buff *frm, uint8_t *sta_mac, uint8_t *bssid, uint8_t rcpi);

struct cmdu_buff *agent_gen_vendor_specific_probe_req(
	struct agent *a,
	uint8_t *sta_mac,
	uint8_t *bssid,
	uint8_t rcpi);

int handle_vendor_extension(void *agent, struct cmdu_buff *rx_cmdu, struct node *n);

#endif

#endif /* VENDOR_H */ 
