#ifndef DYNBH_H
#define DYNBH_H

#include <libubox/list.h>
#include <libubus.h>
#include <stdbool.h>
#include <stdint.h>
#include <timer_impl.h>

#define MAP_UPLINK_PATH 	"/var/run/multiap/multiap.backhaul"

#ifdef PERSIST_CONTROLLER
enum cntlr_discovery_mode {
	DYNAMIC_CNTLR_MODE_AUTO,
	DYNAMIC_CNTLR_MODE_DISABLED,
	DYNAMIC_CNTLR_MODE_CONTROLLER,
};
#endif


struct ethport {
	bool connected;
	bool loop;
	bool active_uplink;
	char ifname[16];
	uint8_t backhaul_mac[6];
	uint8_t backhaul_device_id[6];
	uint8_t num_mid;
	uint16_t mid[32];
	atimer_t bridge_add;
	atimer_t send_apconf;
	int retries;
	atimer_t send_dhcp_discovery;
	int dhcp_retries;
	struct list_head list;
	struct dynbh_ctx *ctx;
};

struct dynbh_ctx {
	char alidstr[16]; /* 6 octet macaddr without separators */
	char al_bridge[16];
	uint16_t cmdu_mask;
	struct ubus_context *ctx;
	uint32_t oid;
	uint32_t map_oid;
	void *subscriber;
	struct ubus_event_handler evh;
	int queued_searches;
	struct list_head ethportlist; /*  */
	atimer_t heartbeat;
	struct ubus_object obj;
#ifdef PERSIST_CONTROLLER
	enum cntlr_discovery_mode discovery_mode;
#endif

};

void delif(struct ethport *port);
void addif(struct ethport *port);


struct ethport *ethport_by_ifname(struct dynbh_ctx *p,
		const char *ifname);
struct ethport *ethport_by_mid(struct dynbh_ctx *p, uint16_t mid);

void dynbh_handle_port_up(struct ethport *port);
void dynbh_handle_port_down(struct dynbh_ctx *priv, struct ethport *port);

void free_ethport_search(struct ethport *port);

#endif
