#!/bin/bash
#set -e
echo "compile warns stage"

function exec_cmd()
{
	echo "executing $@"
	output=$( "$@" 2>&1 )
	local ret=$?

	echo "$output"

	if [ "${ret}" -ne 0 ]; then
		echo "Failed compilation ret (${ret})"
		exit 1
	fi
}

pwd

cd src/
# make without any flags set
exec_cmd make clean
CFLAGS+="-I/usr/include/libnl3 -Werror -Wall -DEASYMESH_VERSION=6 \
-Wno-error=deprecated-declarations" exec_cmd make
# all flags set, EM ver 6
exec_cmd make clean
CFLAGS+="-I/usr/include/libnl3 -Werror -Wall -DAGENT_ISLAND_PREVENTION \
-DAGENT_DYNAMIC_CNTLR -DAGENT_SYNC_DYNAMIC_CNTLR_CONFIG -DOPER_CHAN_CHANGE_RELAY_MCAST \
-DEASYMESH_VERSION=6 -DUSE_LIBDPP -DUNASSOC_STA_CONT_MONITOR \
-Wno-error=deprecated-declarations" exec_cmd make
# all flags set, EM ver 4
exec_cmd make clean
CFLAGS+="-I/usr/include/libnl3 -Werror -Wall -DAGENT_ISLAND_PREVENTION \
-DAGENT_DYNAMIC_CNTLR -DAGENT_SYNC_DYNAMIC_CNTLR_CONFIG -DOPER_CHAN_CHANGE_RELAY_MCAST \
-DEASYMESH_VERSION=4 -DUSE_LIBDPP -DUNASSOC_STA_CONT_MONITOR \
-Wno-error=deprecated-declarations" exec_cmd make
# all flags set, EM ver 2
exec_cmd make clean
CFLAGS+="-I/usr/include/libnl3 -Werror -Wall -DAGENT_ISLAND_PREVENTION \
-DAGENT_DYNAMIC_CNTLR -DAGENT_SYNC_DYNAMIC_CNTLR_CONFIG -DOPER_CHAN_CHANGE_RELAY_MCAST \
-DEASYMESH_VERSION=2 -DUNASSOC_STA_CONT_MONITOR \
-Wno-error=deprecated-declarations" exec_cmd make
