#ifndef UNASTA_H
#define UNASTA_H

#include <timer_impl.h>
#include <stdint.h>
#include <time.h>

#define UNASSOC_STA_MEAS_RETRY_TIME (3 * 1000) /* 3 sec */
#define UNASSOC_STA_MEAS_MAXTRIES 5

struct agent;
struct cmdu_buff;
struct tlv_unassoc_sta_link_metrics_query;
struct netif_ap;
struct wifi_radio_element;

struct wifi_sta_measurement {
		uint8_t opclass;
		uint8_t channel;
		int8_t rssi;
		uint8_t rcpi;
		int last_seen_ms;
		/* of most recent measurement */
		struct timespec start_time;
		/* num of failed measurements */
		int num_tries;
};

struct wifi_unassoc_sta_element {
	uint8_t macaddr[6];
	char mon_ifname[16];
	bool is_monitored;
	struct timespec last_request_t;
	struct wifi_sta_measurement meas;

	struct list_head list;
};

void clear_unassocstalist_in_radio(struct wifi_radio_element *re);
void clear_unassocstalist(struct agent *a);
int unassoc_sta_send_link_metrics_response(struct wifi_radio_element *re);
int agent_process_unassoc_sta_lm_query_tlv(struct agent *a,
		struct tlv_unassoc_sta_link_metrics_query *query,
		struct cmdu_buff *cmdu);

int agent_del_unassoc_sta(struct agent *a, uint8_t *macaddr);
struct wifi_unassoc_sta_element *radio_get_unassoc_sta(struct wifi_radio_element *re, uint8_t *sta);
struct wifi_unassoc_sta_element *radio_monitor_unassoc_sta(struct wifi_radio_element *re,
			uint8_t *sta_mac, uint8_t opclass, uint8_t channel, bool *param_change);
#endif
