/*
 * timer.h
 * Header file for timer utility functions.
 *
 * Copyright (C) 2021 IOPSYS Software Solutions AB. All rights reserved.
 *
 * Author: anjan.chanda@iopsys.eu
 *
 * See LICENSE file for license related information.
 *
 */

#ifndef ATIMER_H
#define ATIMER_H

#include <stdbool.h>
#include <stdint.h>
#include <timer_impl.h>

struct timespec;

#ifndef ATIMER_T
#error "atimer_t not defined!"
#endif

void timer_init(atimer_t *t, void (*function)(atimer_t *));
int timer_set(atimer_t *t, uint32_t tmo_ms);
int timer_del(atimer_t *t);
int timer_pending(atimer_t *t);
int timer_remaining_ms(atimer_t *t);

bool timestamp_less_than(const struct timespec *lhs, const struct timespec *rhs);
bool timestamp_greater_than(const struct timespec *lhs, const struct timespec *rhs);
bool timestamp_greater_or_equal(const struct timespec *lhs, const struct timespec *rhs);
bool timestamp_less_or_equal(const struct timespec *lhs, const struct timespec *rhs);

char *time_to_timestr(const time_t *t, char *tsp);
time_t timestr_to_time(const char *tsp);

#endif /* ATIMER_H */
