/*
 * extension.h - CMDU extension plugin header
 *
 * Copyright (C) 2023 IOPSYS Software Solutions AB. All rights reserved.
 *
 * Author: anjan.chanda@iopsys.eu
 *
 * See LICENSE file for license related information.
 *
 */

#ifndef CMDU_EXTENSION_PLUGIN_H
#define CMDU_EXTENSION_PLUGIN_H

#include <libubox/list.h>
#include <stddef.h>
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

enum cmdu_extend_location {
	CMDU_RX      = (1 << 0),
	CMDU_PRE_TX  = (1 << 1),
	CMDU_EXTEND_NUM,
};

typedef enum cmdu_res {
	CMDU_OK,	/* continue processing */
	CMDU_DROP,	/* drop cmdu */
	CMDU_DONE,	/* don't process further */
} cmdu_res_t;

struct cmdu_extend_mask {
	uint16_t type;	/* cmdu type */
	uint8_t loc;	/* CMDU_RX or CMDU_PRE_TX */
};

typedef struct cmdu_extend_mask cmdu_extend_mask_t[128];


struct plugin {
	char name[128];
	uint8_t oui[3];
	void *priv;
	int (*init)(void **priv, void *cookie);
	void (*exit)(void *priv);
	int (*start)(void *priv);
	int (*stop)(void *priv);

	cmdu_extend_mask_t mask;
	int (*process_cmdu)(void *priv, uint8_t *src, void *cmdu, size_t cmdulen);
	void *handle;
	struct list_head list;
};

int cmdu_set_extension_mask(void *plugin, ...);

int map_send_cmdu(void *cookie, uint8_t *dst, uint8_t *src, uint16_t type,
		  uint16_t *mid, uint8_t *data, size_t len, uint16_t tag);


#ifdef __cplusplus
}
#endif

#endif /* CMDU_EXTENSION_PLUGIN_H */
