#ifndef DPP_H
#define DPP_H

#if (EASYMESH_VERSION >= 3)
#ifdef USE_LIBDPP

#include <libubox/list.h>
#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>
#include <timer_impl.h>
#include <easy/utils.h>
#include <easy/if_utils.h>
#include <wifidefs.h>
#include <dpp_api.h>

struct agent;
struct blob_attr;


#define DPP_KEY_FILE "/etc/multiap/dpp_keys.json"
#define DPP_FRAG_SIZE 1000
#define DPP_MAX_CH_OPCLASS 16


struct dpp_frame {
	uint8_t *frame;
	uint16_t framelen;
	uint8_t id;
	bool lastframe;
	uint8_t src[6];
	struct list_head list;
	atimer_t ageout;
};

uint32_t channel_to_freq(enum wifi_band band, uint32_t channel);
const char *dpp_frame_type2str(uint8_t type);

struct dpp_frame *dpp_get_config_resp(struct agent *a, uint8_t dialog_token, uint8_t *src);

struct dpp_frame *dpp_frame_init(struct agent *a, uint8_t *frm,
				 uint16_t framelen, uint8_t id,
				 uint8_t *src, int tmo);

void dpp_sta_event_handler(void *c, struct blob_attr *msg);
#if 0
int dpp_get_keys(struct agent *a);
int dpp_gen_keypair(struct agent *a);
#endif
int dpp_frame_handler(void *dpp, uint8_t *smac, enum dpp_event ev,
		      uint8_t *frame, size_t framelen);
int dpp_send_wifi_frame(struct agent *a, char *ifname, uint8_t *dst,
			uint16_t frametype, uint8_t *frame, uint32_t freq,
			size_t framelen);
void dpp_send_event(struct agent *a);
void dpp_legacy_timeout_cb(atimer_t *t);
void dpp_send_chirp(atimer_t *t);
void dpp_advertise_cce(struct agent *a, char *ifname, bool enable);
#endif /* USE_LIBDPP */
#endif
#endif
