# Map-agent APIs

Overview of the exposed UBUS API.

## UBUS API

Map-agent APIs exposed over the microbus are primarily used by scripts or other
applications for IOPSYS add-on features. However, also include APIs to form CMDU
requests to gather necessary data for the map-agent internally maintained
representation of the network nodes.

### API Dump
```
root@nvg578m-a0e7ae917984:~# ubus -v list map.agent
'map.agent' @ca2cc722
	"apconfig":{"band":"Integer"}
	"steer_policy":{"vif":"String","rule":"String"}
	"steer":{"vif":"String","type":"String","sta":"String","to_bss":"Array","optime":"Integer"}
	"assoc_control":{"vif":"String","sta":"String","enable":"Boolean","time":"Integer"}
	"toggle_fh":{"enable":"Boolean","prevent_island":"Boolean","ifname":"String"}
	"bcn_metrics_query":{"agent":"String","sta":"String","opclass":"Integer","channel":"Integer","bssid":"String","reporting_detail":"Integer","ssid":"String","channel_report":"Array","request_element":"Array"}
	"unassoc_sta_lm_query":{"agent":"String","opclass":"Integer","metrics":"Array"}
	"topology_query":{"agent":"String"}
	"higher_layer_data":{"agent":"String","protocol":"Integer","data":"String"}
	"backhaul_info":{}
	"status":{}
	"nodes":{}
	"info":{}
	"assoc_notify":{"bss_status_list":"Array"}
	"sync":{}
	"timers":{}
	"dynamic_backhaul_upgrade":{}
	"backhaul_blacklist":{}
	"bss_config_request":{}
	"dpp_enrollee_uri":{}
```

### API Table

| Method  		   | CMDU					 | Description 													   |
|--------------------------|---------------------------------------------|-----------------------------------------------------------------------------------------------------------------|
|apconfig	   	   | AP-Autoconfiguration Search		 | **Obsolete API**   												   |
|steer_policy		   | N/A					 | **Obsolete API**							 					   |
|steer			   | N/A					 | **Deprecated** Legacy method to locally trigger eer 	 							   |
|assoc_control		   | N/A					 | **Deprecated** Legacy method to locally perform association ontrol  						   |
|toggle_fh		   | N/A			 		 | Enable or disable a fronthaul, used by IOPSYS Add-on features (i.e. island prevention) 			   |
|bcn_metrics_query	   | Beacon Metrics Query			 | Request beacon metrics from a client										   |
|unassoc_sta_lm_query	   | Unassociated STA Link Metric Query		 | Trigger monitoring of an unassociated client, on a set of channels						   |
|topology_query		   | Topology Query				 | Request for network topology information									   |
|higher_layer_data	   | Higher Layer Data				 | Send opaque payload over 1905 abstraction layer								   |
|backhaul_info		   | Topology Discovery		 		 | Show information about backhaul link currently in use							   |
|status			   | N/A				 	 | Show information gathered for radios, APs and clients	 						   |
|nodes		   	   | CMDUs with Multi-AP Profile TLV		 | Show all nodes and their supported EasyMesh profile 								   |
|info		   	   | N/A			 		 | Show active controller ALID and debug information 							 	   |
|assoc_notify		   | Association Status Notification		 | Send associaton status message, to inform whether connections are allowed					   |
|sync		   	   | Higher Layer Data 		 		 | Request latest active map-controller configuration to apply to locally dormant map-controller *IOPSYS Add-on*   |
|timers			   | N/A			 		 | Show internal timers, primarily used for debugging							   	   |
|dynamic_backhaul_upgrade  | N/A					 | Immediately trigger an backhaul STA upgrade oppertunity window and start scanning, based on configured priority |
|backhaul_blacklist	   | Topology Response				 | Show local backhaul blacklist, maintained in order to prevent connecting to a downstream backhaul BSS	   |
|bss_config_request	   | BSS Config Request				 | Trigger BSS configuration											   |
|dpp_enrollee_uri	   | N/A					 | Show DPP Enrollee QR code						   					   |
