#ifndef ASSOC_CTRL_H
#define ASSOC_CTRL_H

#include <stdbool.h>
#include <stdint.h>

struct agent;
struct netif_ap;

#if defined MAX_STA && MAX_STA > 0 && MAX_STA <= 32
#define ASSOC_CTRL_MAX_STA MAX_STA
#else
#define ASSOC_CTRL_MAX_STA 32
#endif

#define ASSOC_CTRL_FILE "/etc/multiap/assoc_ctrl.json"

int assoc_ctrl_block_sta(struct agent *a, struct netif_ap *ap,
		uint16_t validity_period, uint8_t mode,
		uint32_t sta_count, uint8_t stalist[][6]);
int assoc_ctrl_unblock_sta(struct agent *a, struct netif_ap *ap,
		uint32_t sta_count, uint8_t stalist[][6]);
int assoc_ctrl_sync_from_file(struct agent *a, struct netif_ap *ap);
int assoc_ctrl_apply_restriction(struct agent *a, struct netif_ap *ap);
int assoc_ctrl_process_request(void *agent, uint8_t *p, struct cmdu_buff *cmdu);
int assoc_ctrl_reapply(struct netif_ap *ap);
#endif
