#ifndef BACKHAUL_H
#define BACKHAUL_H

#include <stdbool.h>
#include <stdint.h>
#include <timer_impl.h>

struct agent;
struct netif_bk;

void dynbh_update_agent_connect_t(struct agent *a);
void dynbh_update_agent_disconnect_t(struct agent *a);
void dynbh_update_bk_connect_t(struct agent *a, struct netif_bk *bk);
void dynbh_update_bk_disconnect_t(struct agent *a, struct netif_bk *bk);

void dynbh_bsta_enable_all(struct agent *a);
void dynbh_bsta_swap_to_link(struct agent *a, char *ifname);
void dynbh_bsta_use_link(struct agent *a, char *ifname);
void dynbh_bsta_disable_lower_priority(struct agent *a, char *ifname);
void dynbh_bsta_scan_on_enabled(struct agent *a);
void dynbh_bsta_clear_bssid(struct agent *a, char *ifname);

struct netif_bk *dynbh_get_best_connected_bsta(struct agent *a);
uint8_t dynbh_get_best_bsta_priority(struct agent *a);

void dynbh_upgrade_backhaul_cb(atimer_t *t);
void dynbh_bh_reconf_cb(atimer_t *t);
void dynbh_bh_lost_cb(atimer_t *t);
void dynbh_disable_unconnected_bsta_cb(atimer_t *t);
int dynbh_handle_bh_lost(struct agent *a, struct netif_bk *bk);

void agent_check_bsta_connections(struct agent *a);
void agent_manage_bsta(struct agent *a, struct netif_bk *bk);
bool agent_is_bsta_connected(struct agent *a);
bool agent_is_bsta_onboarded(struct agent *a);
bool agent_is_backhaul_type_eth(void);
bool agent_has_active_backhaul(struct agent *a);
char *agent_get_backhaul_ifname(struct agent *a, char *ifname);
void agent_trigger_bsta_sync(atimer_t *t);
void agent_update_active_uplink(struct agent *a, struct netif_bk *bk);
#endif
